//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//      Picture Frame Script  v1.0.0
//      Deco Script for Photoshop
//      Daichi Ito, Technical Artist
//
//      (c) Adobe Systems Inc.  2013
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////

modelParameters = {
    frameNumber : 43, 
    frameMargin : 14,
    size : 20, 
    width : 5,
    nlines : 15,
    angle : 10,
    flowerNumber : 2,
    flowerSize : 20,
//    bgColor : false,
    flip : false,
    leafNumber : 4,
    leafSize : 20,
    fade : 0,
    vcolor : [64/255,84/255,35/255],    
    fcolor : [0/255,88/255,220/255],
    lcolor : [128/255, 215/255, 72/255],
    arrange : 1,

}                      

var outputSize 
var outputOrigin 
var outputSizeX
var outputSizeY 

// Get pattern and its size

RenderAPI.setParameter (kpsUseOpenGL, 1);



// gloval variables

var frameScale;

var total;

var sSize1;
var sSizeRandom;
var sSizeRatio;
var sSizeCos;
var sColor;

var cColorFade;
var cContinuous;
var curveVisible;

var cGenerationN;
var cgSizeRatio;
var cgSizeRandom;

var sRotate;
var sRotateRandom;

var flip;

var curveRatio;
var margin;

var spiral;
var pType;
                          
var ipWidth;
var pWidth;
var trunk;
var tWidth;
var trunkType;
var fWidth;

var leavesType;
var leaves;
var sLeaves;
var basePatternNumber;
var sCircle;
var sCircleSize;
var sCircleSizeRatio; 
var sCircleSizeRandom;
var scColor;

var tail;
var patternPattern;
var patternRatio;

var angle;
var angleRatio;
var angleRandom;

var objAngleSnap;

var tBoxStyle;
var tbRadius; 
var tbWidth;
var tbr;
var tbg;
var tbb;


// shapes

var shape = new Array();

shape[00] = [18,31.833,15.5,31.75,13.5,31.167,10.917,30,9,28.667,7.5,27.167,6.083,25.167,5,22.667,4.417,20.5,4.25,18.167,4.5,15.917,5.167,13.667,6,11.667,7.167,9.917,8.5,8.417,10,7.167,11.333,6.333,12.917,5.583,14.583,5,16.167,4.667,18,4.583];
shape[01] = [54,32.083,40.417,32.083,40.417,4.667,54,4.667];
shape[02] = [90,31.583,88.417,31.583,86.333,27.167,84.667,22.583,83.417,18.167,83,15.667,82.917,13.583,83.083,11.25,83.75,9.083,84.75,7.167,85.917,6,87.5,5.083,88.833,4.667,90,4.5];
shape[03] = [125.917,31.5,124,29.5,122.5,27.25,121.417,24.917,120.667,22.667,120.25,20.417,120.083,18.083,120.25,15.667,120.75,13.583,121.583,11.167,122.667,9.167,124.083,6.833,126,4.667];
shape[04] = [162.083,31.583,159.833,30.833,158.167,29.417,157.083,27.75,156.25,25.667,155.917,23.583,156,21.083,156.583,18.833,157.417,16.833,158.333,14.583,159.583,12.083,160.583,9.833,161.333,8,161.75,6.417,162,4.583];
shape[05] = [197.917,31.5,197,28.833,195.75,26.25,194.583,23.667,193.333,20.75,192.417,18.083,191.833,15.583,191.75,13.417,192.083,10.75,192.75,8.417,193.75,6.833,195.083,5.5,196.417,4.833,198,4.5];
shape[06] = [234,31.583,233.25,30.083,232,28.333,230,25.833,228.417,23.667,227.083,21.5,226,19.083,225.25,16.667,224.917,13.833,227,14.5,229.333,15.417,229.667,13.417,230.583,11.333,231.5,9.667,232.667,7.833,233.417,6.417,234,4.667];
shape[07] = [269.917,31.583,263.083,31.583,261,30.417,259,28.75,257.75,27.167,256.917,25,256.833,23.25,257.75,20.917,259.25,19.583,260.833,19,262.417,19.167,263.5,19.583,264,17.583,265.25,15.583,266.417,14.5,268.167,13.75,270,13.583];
shape[08] = [305.917,31.583,304.083,29.5,301.583,27.167,299.333,25.583,297.333,24.417,295.083,23.417,292.417,22.75,294.75,21.583,297.333,21.083,299.5,21.083,301.75,21.417,300.917,19.083,300.75,16.417,301.167,13.833,301.75,11.667,302.75,9.083,303.75,6.833,304.667,4.667,305.5,2.583,306,0.167];
shape[09] = [341.917,31.5,341,28.75,339.833,26.583,338.333,24.417,336.833,22.75,335.417,21.25,333.5,19.75,331.917,18.833,330.667,18.167,331.917,16.583,333.5,15.083,335.333,13.833,337.333,12.833,339.25,12.25,340.667,12,341.917,12];
shape[10] = [377.917,31.583,369,13.75,378,13.75];
shape[11] = [414,31.667,411.667,29.75,409.583,28.25,407.083,26.667,405,25.083,403.083,23.083,401.667,21.083,401,19.583,400.583,18.25,402.833,17.333,405.333,16.667,406.833,16.333,408.417,16.333,408.083,14.75,408.167,12.583,408.917,10.417,409.833,8.25,410.75,6.583,411.667,5,412.833,3.083,413.583,1.583,414,0.167];
shape[12] = [450,31.583,449.083,29.5,447.667,27.667,446.25,26.333,444.75,25,443.583,24.167,442.583,23.583,440.917,22.75,442.917,21.833,444,20.833,444.917,19.75,445.5,18.75,446.333,17.25,447.083,15.333,447.833,12.75,448.417,10.167,449.333,5.25,450,0.083];
shape[13] = [485.917,31.583,484.667,31.25,483.667,30.333,482.833,28.75,482.167,26.417,481.583,22.833,481.417,19.167,481.5,15.333,481.667,11.833,482.083,8.5,482.583,5.333,483.25,3.083,484,1.5,484.667,0.583,485.333,0.25,486,0];
shape[14] = [521.917,31.583,517.417,31.583,508.417,13.5,521.917,13.5];
shape[15] = [558.083,31.542,556.583,31.542,556.583,15.917,555.208,15.542,554.021,14.854,552.896,13.917,552.021,12.854,551.271,11.479,550.896,9.854,550.958,8.292,551.271,6.854,551.708,5.729,552.333,4.792,553.208,3.792,554.271,2.979,555.271,2.417,556.646,2.042,558.083,1.917];
shape[16] = [594.083,31.667,591.271,31.667,589.896,29.729,588.521,27.542,587.271,25.042,586.146,22.542,585.396,20.292,584.958,17.979,584.896,15.917,585.208,14.042,585.708,12.292,586.458,10.854,587.521,9.542,588.896,8.104,590.333,6.917,591.771,5.729,592.771,4.792,593.583,3.854,594.083,2.604];
shape[17] = [18.021,67.438,17.833,65.75,17.333,64,16.521,62.25,15.521,60.5,14.396,59.125,13.146,57.688,11.771,56.688,10.146,55.625,8.771,54.938,7.271,54.5,5.896,54.125,4.521,53.875,6.458,53.688,8.083,53.25,9.583,52.688,10.896,51.938,12.271,50.938,13.646,49.688,14.708,48.562,15.771,47.188,16.708,45.625,17.396,43.938,17.833,42.438,18.083,40.688];
shape[18] = [54.021,67.625,52.896,67.312,52.146,66.625,51.583,65.5,51.396,63.938,51.458,61.938,51.458,59.812,51.333,57.75,50.958,55.688,50.458,54.125,49.646,52.438,48.333,50.812,47.396,49.125,46.771,46.75,46.646,45.125,46.833,43.312,47.458,41.938,48.396,40.625,49.646,39.375,50.958,38.438,52.333,37.812,54.083,37.438];
shape[19] = [90.146,67.438,85.583,67.438,85.583,58.75,76.583,58.75,76.583,49.438,85.646,49.438,85.646,40.5,90.146,40.5];
shape[20] = [126.083,63,124.583,64.167,123,65,121.083,65.5,119.333,65.5,117.667,65.084,116.083,64.334,114.833,63.334,113.583,61.75,112.833,60.25,112.333,58.584,112.417,56.5,112.667,54.584,113.333,52.584,114.25,50.75,115.667,48.584,117.167,46.75,118.583,45.25,120.167,43.667,121.75,42.167,123.583,40.5,125,39.167,126.083,37.584];
shape[21] = [162.417,67.417,157.667,67.417,157.667,49.417,148.75,49.417,148.75,40.25,162.333,40.25];
shape[22] = [198.167,45.568,189.345,39.159,192.715,49.529,183.893,55.938,194.797,55.938,198.167,66.309];

var sShape = new Array();
sShape[00] = [17.917,211.584,18,207.084,18.333,202.5,19,198,19.833,195,20.917,192.25,22.167,190.084,23.75,188.25,25.5,186.917,27.167,186.167,29.167,186.084,30.833,186.584,31.917,187.667,32.083,189.084,31.583,190.417,29.917,191.584,27.833,192.75,25.75,194.167,24,195.5,22.417,197,21,198.917,19.833,201.084,19,203.5,18.333,206.334]
sShape[01] = [54,211.5,54.083,207.084,54.333,203.667,54.833,200.084,55.167,197.584,55.667,195.084,56.417,192.334,57.167,190.334,58,188.834,59,187.667,60.083,187.25,61.083,187.5,61.833,188.084,62,189.334,61.667,190.417,60.917,192.25,59.333,195,62.167,191.167,63.917,189.25,66.417,187.084,68.583,185.584,70.25,184.917,71.833,184.667,73.083,184.917,73.75,185.667,74,186.834,73.667,187.917,72.917,188.834,71.5,190.167,69.917,191.417,67.833,192.917,65.583,194.417,63.333,196.167,61.25,198,59.333,200.084,58.167,201.584,56.583,203.917,55.667,205.584,54.833,207.667,54.333,209.25]
sShape[02] = [90,211.5,89.917,208.417,89.75,205.334,89.833,202.417,90.25,200.292,91.042,198.125,92,196.458,93.125,194.875,94.292,193.417,95.583,192.083,96.875,190.667,98.125,189.417,97.042,191.75,96.167,194.083,95.625,195.917,94.875,197.917,93.792,200.292,95.542,197.375,97.208,195.167,99.125,193,100.708,191.458,102.75,189.75,105.125,187.958,107.833,186.292,111.125,184.5,109.25,186.208,107.583,188.292,106.375,190.25,105.167,192.375,104,194.5,103.083,195.75,102,197.083,104.542,195.625,106.417,194.875,108.542,194.25,110.667,193.667,112.75,193.375,114.708,193.292,116.75,193.333,118.042,193.458,116.083,194.125,114.458,194.958,112.458,196.125,110.792,197.208,108.667,198.667,106.792,199.75,104.792,200.792,102.625,201.542,100.167,202.167,98.167,202.708,95.75,203.625,94.125,204.458,92.667,205.583,91.5,206.875,90.833,208.125,90.375,209.25]
sShape[03] = [125.917,211.542,125.958,209.458,126.25,207.208,126.792,204.375,127.333,202.5,127.958,200.917,128.792,199.417,129.542,198.125,130.542,196.708,131.75,195.333,133.417,193.75,134.75,192.792,136.5,191.875,138.125,191.333,140.125,191.125,141.667,191.292,143.083,191.75,144.417,192.542,145.333,193.542,146.125,194.667,146.667,196.042,146.875,197.25,146.667,198.375,146.125,199.75,145.417,200.708,144.417,201.542,143.458,202.083,142.167,202.333,140.792,202.292,139.875,201.917,138.708,201.208,137.875,200.333,137,199.583,135.958,199.208,134.875,199.083,133.667,199.208,132.375,199.542,131.167,200.208,129.917,201.042,128.875,202.042,128.125,203.042,127.542,203.958,126.875,205.375,126.292,207.542]
sShape[04] = [161.958,211.667,161.167,210.292,160.667,208.542,160.625,206.542,161,204.25,161.417,202.458,162.333,200.125,163.125,198.5,164.292,196.583,165.375,195.083,166.625,193.542,168.125,192.125,170.083,190.792,171.667,189.875,173.25,189.208,175.125,188.833,176.917,188.667,178.75,188.75,180.25,189.042,181.667,189.5,182.667,189.917,181.667,192.917,180.417,192.542,178.75,192.167,176.917,192.042,175.375,192.292,174.083,192.583,172.792,193.208,171.5,193.917,170,195.125,168.667,196.542,167.292,198.5,166.25,200.333,165.708,201.958,165,204.208,164.375,206.083,163.708,208.417,163.167,209.75,162.583,210.75]
sShape[05] = [197.938,211.583,197.875,207.521,197.875,204.146,198.188,201.271,198.75,199.021,199.875,196.833,201.375,195.271,203.312,194.021,205.812,193.021,208.25,192.458,210.688,192.208,213.688,192.146,216,191.958,218.25,191.458,220.062,190.771,221.625,189.771,222.812,188.521,223.812,187.083,224.438,185.396,224.375,187.958,223.75,190.396,222.938,192.271,221.875,193.646,219.688,195.208,217.438,196.083,215.312,196.583,212.688,196.958,209.562,197.583,206.875,198.271,204.625,199.146,203.125,200.208,201.312,201.958,200.125,203.521,199.312,204.833,198.75,206.396,198.188,208.521]
sShape[06] = [234.875,212.646,234.938,208.146,235.125,204.833,235.688,201.771,236.375,199.208,237.562,196.458,238.812,194.208,240.438,192.333,242.188,190.896,244.188,189.771,246,189.083,247.875,188.708,249.688,188.771,251.562,189.146,253.562,189.958,255.125,191.083,256.438,192.646,257.375,194.396,257.75,196.083,257.5,198,256.167,196.333,254.688,195.146,253.062,194.521,251.125,194.208,249.125,194.271,246.625,194.833,244.625,195.583,242.438,196.958,240.625,198.396,238.812,200.271,237.438,202.271,236.562,204.083,235.812,206.208,235.312,208.521]
sShape[07] = [270.062,211.708,270.062,208.458,270.25,205.708,270.625,202.646,271.375,198.958,272.5,195.333,273.625,192.771,274.938,190.708,276.562,188.958,278.062,187.896,279.5,187.208,278.875,189.021,278.562,190.271,278.375,191.458,280.562,189.896,282.562,188.958,284.875,188.271,287.25,188.021,288.875,188.083,290.062,188.333,288.188,189.646,286.812,190.896,285,192.771,287.188,192.583,289.875,192.958,291.938,193.646,293.688,194.583,294.875,195.583,295.875,197.021,293.562,196.833,290.938,197.021,288.25,197.333,285.375,197.958,282.125,199.083,279.438,200.333,277.25,201.521,275.312,202.958,273.812,204.521,272.438,206.208,271.5,207.708,270.625,209.521]

var fnShape = new Array();
var fsShape = new Array();

fnShape[0] = 1;
fsShape[0] = new Array();
fsShape[0][0] = [18.5,270.5];  //center
fsShape[0][1] = [18.438,258.625,16.188,258.875,14.125,259.438,12.312,260.312,10.688,261.562,9.125,263.125,8.125,264.625,7.438,266.062,6.812,268,6.625,269.75,6.688,272,7.188,273.938,7.938,276,9.125,277.812,10.375,279.188,11.875,280.438,13.688,281.438,15.5,282.062,17.688,282.438,19.625,282.375,22,281.875,24.125,280.938,25.938,279.812,27.688,278.188,28.812,276.438,29.75,274.5,30.188,272.375,30.312,270.125,30.062,267.938,29.375,265.75,28.5,264,27.375,262.562,26.25,261.438,24.625,260.312,23.062,259.5,21.438,259,20,258.688];

fnShape[1] = 6;
fsShape[1] = new Array();
fsShape[1][0] = [54.5,270.5];
fsShape[1][1] = [54.461,265.935,53.625,266.028,52.858,266.237,52.184,266.562,51.58,267.027,50.999,267.608,50.627,268.166,50.372,268.7,50.14,269.42,50.069,270.071,50.093,270.908,50.279,271.628,50.557,272.395,50.999,273.069,51.464,273.58,52.022,274.045,52.696,274.417,53.37,274.649,54.183,274.789,54.903,274.766,55.786,274.58,56.577,274.231,57.25,273.812,57.901,273.209,58.319,272.558,58.667,271.837,58.831,271.048,58.877,270.211,58.784,269.397,58.528,268.584,58.203,267.933,57.785,267.399,57.366,266.981,56.763,266.562,56.181,266.26,55.577,266.074,55.042,265.958];
fsShape[1][2] = [54.625,252.562,54.188,253.875,53.375,255.188,52.5,256.125,51.562,257.375,50.75,258.75,50.438,260.312,50.688,261.875,51.062,262.938,51.438,263.562,52.938,263.312,54.625,263.125,56.125,263.125,57.625,263.625,58.375,262,58.625,260.312,58.25,258.688,57.562,257.438,56.688,256.312,55.875,255.312,55.125,254.188];
fsShape[1][3] = [37.495,264.736,38.608,265.558,39.605,266.736,40.227,267.858,41.126,269.136,42.183,270.334,43.572,271.113,45.135,271.358,46.262,271.33,46.972,271.167,47.197,269.663,47.541,268,48.004,266.573,48.943,265.302,47.63,264.086,46.102,263.327,44.441,263.181,43.039,263.449,41.699,263.934,40.497,264.397,39.195,264.763];
fsShape[1][4] = [43.779,284.79,44.905,283.985,46.334,283.401,47.594,283.157,49.086,282.696,50.552,282.062,51.723,280.98,52.438,279.57,52.76,278.49,52.824,277.764,51.464,277.084,49.988,276.244,48.774,275.362,47.855,274.076,46.293,274.95,45.1,276.169,44.447,277.703,44.269,279.119,44.315,280.543,44.385,281.83,44.33,283.181];
fsShape[1][5] = [64.793,285.01,64.376,283.69,64.263,282.151,64.42,280.877,64.442,279.316,64.292,277.726,63.625,276.278,62.506,275.162,61.577,274.522,60.907,274.237,59.84,275.32,58.585,276.464,57.371,277.346,55.864,277.822,56.213,279.579,57.003,281.09,58.26,282.185,59.552,282.792,60.92,283.188,62.166,283.52,63.434,283.989];
fsShape[1][6] = [71.496,265.093,70.113,265.081,68.614,264.714,67.451,264.171,65.974,263.667,64.414,263.318,62.832,263.505,61.424,264.225,60.528,264.91,60.05,265.459,60.751,266.81,61.451,268.356,61.915,269.783,61.902,271.363,63.68,271.574,65.361,271.29,66.791,270.433,67.768,269.392,68.566,268.213,69.268,267.131,70.105,266.07];

fnShape[2] = 9;
fsShape[2] = new Array();
fsShape[2][0] = [90.5,270.5];
fsShape[2][1] = [90.476,267.907,89.984,267.962,89.532,268.085,89.136,268.276,88.781,268.55,88.438,268.892,88.22,269.22,88.069,269.534,87.933,269.958,87.892,270.341,87.905,270.833,88.015,271.257,88.179,271.708,88.438,272.105,88.712,272.406,89.041,272.68,89.437,272.898,89.833,273.035,90.312,273.117,90.736,273.104,91.255,272.994,91.721,272.789,92.117,272.542,92.5,272.188,92.746,271.805,92.951,271.38,93.047,270.916,93.074,270.423,93.02,269.945,92.869,269.466,92.678,269.083,92.432,268.769,92.185,268.523,91.83,268.276,91.488,268.099,91.132,267.989,90.818,267.921];
fsShape[2][2] = [90.562,254.438,89.688,255.5,89.062,256.625,88.688,258.062,88.375,259.625,88.312,261.188,88.5,262.875,88.812,264.375,89.062,265.562,89.375,266.5,90.375,266.375,91.562,266.562,92,265.438,92.375,264.062,92.625,262.562,92.75,261.125,92.688,259.625,92.375,258.188,92,256.75,91.375,255.375];
fsShape[2][3] = [79.143,259.117,79.274,260.486,79.628,261.724,80.379,263.005,81.264,264.332,82.324,265.48,83.649,266.541,84.932,267.381,85.947,268.043,86.832,268.486,87.451,267.69,88.422,266.983,87.937,265.878,87.229,264.641,86.346,263.403,85.418,262.298,84.312,261.282,83.075,260.486,81.793,259.735,80.379,259.205];
fsShape[2][4] = [74.375,270.5,75.438,271.375,76.562,272,78,272.375,79.562,272.688,81.125,272.75,82.812,272.563,84.312,272.25,85.5,272,86.438,271.688,86.312,270.688,86.499,269.501,85.375,269.063,84,268.688,82.5,268.438,81.062,268.312,79.562,268.376,78.125,268.688,76.687,269.063,75.312,269.688];
fsShape[2][5] = [79.054,281.921,80.424,281.788,81.661,281.435,82.943,280.684,84.269,279.8,85.418,278.739,86.479,277.413,87.318,276.131,87.98,275.115,88.423,274.231,87.627,273.612,86.92,272.641,85.815,273.126,84.578,273.833,83.34,274.717,82.236,275.645,81.22,276.751,80.424,277.987,79.672,279.27,79.143,280.684];
fsShape[2][6] = [90.438,286.688,91.312,285.625,91.938,284.5,92.312,283.063,92.625,281.501,92.688,279.938,92.5,278.25,92.188,276.75,91.938,275.563,91.625,274.625,90.625,274.751,89.438,274.564,89,275.688,88.625,277.062,88.375,278.563,88.25,280,88.313,281.501,88.625,282.938,89,284.376,89.625,285.75];
fsShape[2][7] = [101.857,282.009,101.725,280.639,101.371,279.402,100.621,278.121,99.737,276.795,98.676,275.646,97.35,274.584,96.068,273.745,95.053,273.083,94.168,272.64,93.551,273.436,92.578,274.144,93.062,275.248,93.77,276.485,94.654,277.723,95.582,278.827,96.688,279.844,97.924,280.639,99.207,281.392,100.621,281.921];
fsShape[2][8] = [106.625,270.626,105.562,269.751,104.438,269.126,103.001,268.75,101.439,268.438,99.875,268.376,98.188,268.563,96.688,268.876,95.501,269.125,94.562,269.438,94.689,270.437,94.502,271.625,95.625,272.064,97,272.439,98.501,272.688,99.938,272.813,101.438,272.75,102.875,272.439,104.314,272.063,105.688,271.438];
fsShape[2][9] = [101.947,259.206,100.576,259.338,99.34,259.692,98.058,260.441,96.732,261.325,95.583,262.388,94.521,263.713,93.683,264.995,93.02,266.01,92.578,266.895,93.373,267.511,94.081,268.484,95.186,268,96.423,267.293,97.66,266.409,98.765,265.48,99.781,264.375,100.577,263.139,101.329,261.855,101.858,260.441];

fnShape[3] = 11;
fsShape[3] = new Array();
fsShape[3][0] = [126.5,270.5];
fsShape[3][1] = [126.467,261.781,124.818,261.964,123.304,262.376,121.976,263.018,120.786,263.936,119.639,265.082,118.906,266.179,118.402,267.233,117.945,268.653,117.806,269.938,117.852,271.587,118.218,273.008,118.768,274.52,119.639,275.849,120.557,276.856,121.656,277.774,122.985,278.507,124.314,278.966,125.917,279.241,127.338,279.195,129.079,278.829,130.638,278.141,131.965,277.315,133.25,276.125,134.075,274.842,134.762,273.42,135.083,271.864,135.174,270.213,134.991,268.609,134.485,267.005,133.846,265.721,133.021,264.667,132.195,263.844,131.005,263.018,129.858,262.422,128.667,262.056,127.613,261.827];
fsShape[3][2] = [129.699,255.115,129.367,255.152,129.062,255.235,128.795,255.364,128.556,255.549,128.325,255.779,128.178,256,128.076,256.212,127.984,256.498,127.957,256.756,127.966,257.088,128.04,257.373,128.15,257.677,128.325,257.945,128.51,258.147,128.731,258.332,128.998,258.479,129.266,258.572,129.588,258.627,129.874,258.618,130.224,258.544,130.538,258.406,130.804,258.24,131.062,258,131.229,257.742,131.367,257.456,131.431,257.143,131.45,256.811,131.413,256.489,131.311,256.166,131.183,255.908,131.017,255.696,130.851,255.53,130.611,255.364,130.38,255.244,130.141,255.17,129.929,255.125];
fsShape[3][3] = [112.737,262.79,112.67,263.117,112.655,263.432,112.695,263.727,112.797,264.011,112.944,264.301,113.109,264.51,113.279,264.672,113.522,264.847,113.76,264.953,114.078,265.047,114.372,265.065,114.695,265.055,115.004,264.97,115.254,264.857,115.498,264.704,115.721,264.496,115.891,264.27,116.043,263.98,116.123,263.706,116.16,263.35,116.126,263.009,116.051,262.704,115.902,262.384,115.709,262.146,115.479,261.927,115.201,261.769,114.892,261.648,114.573,261.584,114.235,261.581,113.949,261.624,113.697,261.716,113.488,261.823,113.256,261.999,113.07,262.181,112.926,262.386,112.817,262.574];
fsShape[3][4] = [114.795,281.293,115.086,281.458,115.38,281.569,115.673,281.622,115.975,281.613,116.296,281.562,116.546,281.47,116.752,281.358,116.994,281.182,117.168,280.988,117.355,280.715,117.465,280.441,117.555,280.13,117.569,279.811,117.539,279.538,117.469,279.259,117.34,278.982,117.177,278.751,116.949,278.517,116.713,278.355,116.385,278.21,116.051,278.138,115.737,278.115,115.387,278.157,115.102,278.268,114.821,278.419,114.585,278.634,114.375,278.891,114.215,279.174,114.108,279.494,114.061,279.779,114.07,280.048,114.107,280.279,114.203,280.555,114.319,280.788,114.47,280.989,114.614,281.149];
fsShape[3][5] = [133.028,285.054,133.275,284.827,133.472,284.583,133.613,284.32,133.697,284.03,133.748,283.709,133.738,283.443,133.695,283.212,133.602,282.928,133.472,282.702,133.27,282.439,133.043,282.251,132.775,282.069,132.477,281.957,132.207,281.901,131.92,281.882,131.617,281.919,131.347,282.003,131.054,282.146,130.827,282.321,130.588,282.589,130.416,282.884,130.297,283.175,130.229,283.522,130.246,283.827,130.303,284.141,130.435,284.432,130.614,284.71,130.834,284.95,131.105,285.15,131.362,285.284,131.62,285.358,131.852,285.394,132.144,285.389,132.4,285.35,132.639,285.269,132.836,285.181];
fsShape[3][6] = [142.239,268.875,142.101,268.57,141.928,268.307,141.723,268.091,141.473,267.922,141.184,267.774,140.928,267.702,140.694,267.671,140.395,267.672,140.141,267.726,139.828,267.837,139.578,267.994,139.323,268.193,139.123,268.442,138.988,268.682,138.881,268.949,138.822,269.248,138.818,269.531,138.864,269.854,138.961,270.124,139.141,270.434,139.368,270.688,139.609,270.892,139.917,271.064,140.213,271.142,140.528,271.185,140.846,271.149,141.167,271.064,141.463,270.93,141.737,270.733,141.943,270.53,142.094,270.308,142.199,270.099,142.284,269.819,142.326,269.563,142.324,269.312,142.301,269.097];
fsShape[3][7] = [126.438,255.5,125.188,255.562,123.75,255.688,122.25,256.125,120.875,256.562,119.562,257.125,118.312,257.875,117.125,258.812,115.688,260.188,117.062,261.438,118.25,260.375,119.5,259.5,120.875,258.75,122.125,258.188,123.75,257.75,125,257.562,126.438,257.438];
fsShape[3][8] = [112.231,265.822,111.904,267.03,111.579,268.436,111.532,269.997,111.522,271.44,111.652,272.862,111.979,274.283,112.504,275.702,113.367,277.494,114.981,276.573,114.338,275.115,113.892,273.656,113.604,272.116,113.454,270.754,113.541,269.073,113.749,267.826,114.074,266.42];
fsShape[3][9] = [117.658,282.522,118.706,283.207,119.942,283.95,121.413,284.478,122.782,284.933,124.175,285.249,125.628,285.376,127.139,285.316,129.11,285.049,128.733,283.229,127.147,283.391,125.621,283.364,124.068,283.162,122.727,282.884,121.155,282.282,120.033,281.698,118.797,280.955];
fsShape[3][10] = [135.218,282.521,136.192,281.736,137.282,280.791,138.238,279.555,139.094,278.394,139.824,277.166,140.396,275.824,140.806,274.369,141.159,272.411,139.313,272.207,138.977,273.765,138.479,275.208,137.808,276.623,137.128,277.813,136.07,279.122,135.168,280.008,134.079,280.954];
fsShape[3][11] = [140.644,265.821,140.198,264.652,139.635,263.323,138.755,262.032,137.915,260.859,136.974,259.785,135.874,258.827,134.617,257.987,132.864,257.047,132.1,258.739,133.478,259.541,134.696,260.459,135.834,261.536,136.756,262.55,137.674,263.96,138.238,265.092,138.801,266.42];

fnShape[4] = 8;
fsShape[4] = new Array();
fsShape[4][0] = [162.5,270.5];
fsShape[4][1] = [163.188,263.5,163.25,261.688,163.125,260,162.625,258.188,161.75,256.688,160.625,255.5,159.312,254.688,157.938,254.25,158.5,255.688,158.562,257.25,158.312,258.938,158.125,260.25,158,261.375,158.562,262.25,159.438,262.75,160.312,263.188,161.5,263.562,160.188,263.875,159.188,264.312,158.188,265,157.625,265.688,158.875,266.812,160,266,161.062,265.5,162.125,265.312,163.062,265.312,163.688,265.438];
fsShape[4][2] = [158.011,265.126,156.773,263.801,155.492,262.696,153.857,261.768,152.178,261.326,150.542,261.282,149.04,261.635,147.758,262.298,149.172,262.917,150.321,263.977,151.338,265.347,152.133,266.408,152.84,267.292,153.857,267.513,154.829,267.248,155.758,266.938,156.862,266.364,156.154,267.513,155.758,268.529,155.537,269.723,155.625,270.606,157.304,270.518,157.525,269.148,157.923,268.043,158.541,267.159,159.204,266.497,159.734,266.143];
fsShape[4][3] = [155.501,269.937,153.688,269.875,152.001,270,150.189,270.499,148.688,271.375,147.501,272.5,146.689,273.812,146.251,275.187,147.688,274.625,149.25,274.562,150.938,274.812,152.25,275,153.375,275.125,154.251,274.561,154.75,273.687,155.189,272.812,155.563,271.625,155.875,272.937,156.314,273.937,157.002,274.937,157.689,275.499,158.813,274.25,158.002,273.124,157.501,272.062,157.312,270.999,157.313,270.062,157.438,269.437];
fsShape[4][4] = [157.127,275.113,155.802,276.351,154.697,277.632,153.77,279.267,153.327,280.947,153.283,282.582,153.637,284.083,154.299,285.366,154.918,283.952,155.978,282.803,157.348,281.787,158.408,280.992,159.293,280.285,159.514,279.267,159.248,278.295,158.939,277.366,158.365,276.262,159.514,276.97,160.531,277.366,161.725,277.587,162.607,277.499,162.52,275.82,161.15,275.599,160.045,275.202,159.159,274.583,158.498,273.92,158.145,273.39];
fsShape[4][5] = [161.938,277.624,161.876,279.436,162,281.123,162.5,282.935,163.375,284.436,164.5,285.623,165.812,286.435,167.188,286.874,166.625,285.436,166.562,283.874,166.812,282.187,167,280.875,167.126,279.75,166.562,278.874,165.688,278.374,164.812,277.935,163.625,277.561,164.938,277.249,165.938,276.81,166.938,276.122,167.5,275.436,166.25,274.311,165.125,275.122,164.063,275.624,163,275.812,162.062,275.811,161.438,275.686];
fsShape[4][6] = [167.113,275.997,168.352,277.322,169.633,278.427,171.268,279.355,172.947,279.797,174.582,279.842,176.085,279.488,177.367,278.826,175.952,278.207,174.805,277.146,173.788,275.777,172.992,274.717,172.286,273.832,171.269,273.611,170.297,273.876,169.367,274.185,168.263,274.759,168.971,273.611,169.367,272.593,169.588,271.399,169.5,270.517,167.82,270.605,167.6,271.975,167.203,273.08,166.584,273.965,165.92,274.627,165.391,274.98];
fsShape[4][7] = [169.623,271.188,171.437,271.249,173.123,271.124,174.936,270.624,176.437,269.75,177.623,268.625,178.436,267.312,178.875,265.937,177.437,266.5,175.875,266.562,174.188,266.312,172.875,266.125,171.75,265.998,170.875,266.562,170.375,267.436,169.936,268.312,169.562,269.5,169.25,268.187,168.811,267.187,168.123,266.187,167.437,265.625,166.311,266.875,167.123,267.999,167.625,269.061,167.812,270.125,167.811,271.062,167.688,271.687];
fsShape[4][8] = [167.998,266.012,169.323,264.773,170.428,263.492,171.355,261.857,171.799,260.177,171.842,258.543,171.488,257.04,170.826,255.757,170.207,257.172,169.147,258.32,167.777,259.336,166.717,260.133,165.832,260.838,165.611,261.855,165.877,262.827,166.186,263.757,166.761,264.862,165.611,264.153,164.594,263.758,163.4,263.536,162.518,263.624,162.605,265.305,163.976,265.525,165.081,265.92,165.966,266.541,166.627,267.205,166.982,267.733];

fnShape[5] = 4;
fsShape[5] = new Array();
fsShape[5][0] = [198.5,270.5];
fsShape[5][1] = [198.5,252.562,198.188,254,197.5,255.375,196.5,256.5,195.5,257.625,194.688,258.75,194.125,260.062,194,261.438,194.188,262.938,194.75,264.562,195.375,265.938,196.25,267.125,197.312,268.375,198.5,269.438,199.688,268.188,200.688,266.938,201.562,265.75,202.25,264.5,202.812,263.188,203.125,262,203,260.562,202.5,259.25,201.688,258.062,200.812,256.938,200.062,256.062,199.5,255.312,199.062,254.5,198.688,253.75];
fsShape[5][2] = [180.562,270.5,182,270.812,183.375,271.5,184.5,272.5,185.625,273.5,186.75,274.312,188.062,274.875,189.438,275,190.938,274.812,192.562,274.25,193.938,273.625,195.125,272.75,196.375,271.688,197.438,270.5,196.188,269.312,194.938,268.312,193.75,267.438,192.5,266.75,191.188,266.188,190,265.875,188.562,266,187.25,266.5,186.062,267.312,184.938,268.188,184.062,268.938,183.312,269.5,182.5,269.938,181.75,270.312];
fsShape[5][3] = [198.5,288.438,198.812,287,199.5,285.625,200.5,284.5,201.5,283.375,202.312,282.25,202.875,280.938,203,279.562,202.812,278.062,202.25,276.438,201.625,275.062,200.75,273.875,199.688,272.625,198.5,271.562,197.312,272.812,196.312,274.062,195.438,275.25,194.75,276.5,194.188,277.812,193.875,279,194,280.438,194.5,281.75,195.312,282.938,196.188,284.062,196.938,284.938,197.5,285.688,197.938,286.5,198.312,287.25];
fsShape[5][4] = [216.438,270.5,215,270.188,213.625,269.5,212.5,268.5,211.375,267.5,210.25,266.688,208.938,266.125,207.562,266,206.062,266.188,204.438,266.75,203.062,267.375,201.875,268.25,200.625,269.312,199.562,270.5,200.812,271.688,202.062,272.688,203.25,273.562,204.5,274.25,205.812,274.812,207,275.125,208.438,275,209.75,274.5,210.938,273.688,212.062,272.812,212.938,272.062,213.688,271.5,214.5,271.062,215.25,270.688];

fnShape[6] = 17;
fsShape[6] = new Array();
fsShape[6][0] = [234.5,270.5];
fsShape[6][1] = [237.452,269.562,237.209,269.029,236.907,268.57,236.549,268.193,236.112,267.897,235.607,267.639,235.16,267.512,234.752,267.458,234.228,267.461,233.785,267.555,233.238,267.749,232.802,268.023,232.356,268.371,232.006,268.806,231.771,269.225,231.583,269.691,231.481,270.214,231.474,270.709,231.554,271.273,231.723,271.744,232.037,272.286,232.435,272.731,232.856,273.086,233.394,273.387,233.911,273.522,234.462,273.598,235.017,273.536,235.578,273.388,236.095,273.152,236.574,272.81,236.935,272.455,237.197,272.066,237.382,271.7,237.53,271.212,237.604,270.765,237.6,270.325,237.559,269.95];
fsShape[6][2] = [234.5,252.625,234.188,254.312,233.812,255.25,233.25,256,233.5,257.312,233.812,259,234,260.875,234.312,264.188,232.875,264.625,232.938,265.562,236,265.5,236.062,264.688,234.625,264.188,234.938,260.875,235.188,259.125,235.438,257.312,235.75,256.125,235.125,255.312,234.75,254.25];
fsShape[6][3] = [216.438,270.438,218.125,270.75,219.062,271.125,219.812,271.688,221.125,271.438,222.812,271.125,224.688,270.938,228,270.625,228.438,272.062,229.375,272,229.312,268.938,228.5,268.875,228,270.312,224.688,270,222.938,269.75,221.125,269.5,219.938,269.188,219.125,269.812,218.062,270.188];
fsShape[6][4] = [234.25,288.5,234.562,286.812,234.938,285.875,235.5,285.125,235.25,283.812,234.938,282.125,234.75,280.25,234.438,276.938,235.875,276.5,235.812,275.562,232.75,275.625,232.688,276.438,234.125,276.938,233.812,280.25,233.562,282,233.312,283.812,233,285,233.625,285.812,234,286.875];
fsShape[6][5] = [252.312,270.688,250.625,270.375,249.688,270,248.938,269.438,247.625,269.688,245.938,270,244.062,270.188,240.75,270.5,240.312,269.062,239.375,269.125,239.438,272.188,240.25,272.25,240.75,270.812,244.062,271.125,245.812,271.375,247.625,271.625,248.812,271.938,249.625,271.312,250.688,270.938];
fsShape[6][6] = [232.125,265.812,229.812,268,228.75,266.562,228.5,264.562,230.688,264.625];
fsShape[6][7] = [229.688,272.75,231.875,275.062,230.438,276.125,228.438,276.375,228.5,274.188];
fsShape[6][8] = [236.625,275.188,238.938,273,240,274.438,240.25,276.438,238.062,276.375];
fsShape[6][9] = [239.062,268.25,236.875,265.938,238.312,264.875,240.312,264.625,240.25,266.812];
fsShape[6][10] = [229.062,257.188,228.875,257.562,228.875,258.5,228.938,259.875,229.25,261.438,229.812,262.938,230.688,263.812,231.562,263.75,232.25,263.312,232.5,262.625,232.375,261.812,232,260.688,231.25,259.5,230.562,258.5,229.5,257.438];
fsShape[6][11] = [221.18,264.905,221.312,265.303,221.975,265.966,222.991,266.894,224.316,267.778,225.775,268.441,227.013,268.441,227.587,267.778,227.764,266.982,227.455,266.319,226.792,265.833,225.73,265.303,224.361,264.994,223.168,264.773,221.665,264.773];
fsShape[6][12] = [221.062,275.937,221.438,276.125,222.375,276.125,223.75,276.062,225.312,275.75,226.812,275.188,227.688,274.312,227.624,273.437,227.188,272.75,226.5,272.499,225.688,272.625,224.562,273,223.375,273.75,222.375,274.438,221.312,275.5];
fsShape[6][13] = [228.779,283.82,229.178,283.688,229.841,283.025,230.77,282.009,231.652,280.684,232.316,279.225,232.316,277.987,231.652,277.413,230.857,277.236,230.193,277.544,229.709,278.208,229.178,279.27,228.869,280.639,228.648,281.832,228.647,283.334];
fsShape[6][14] = [239.811,283.938,239.999,283.563,240,282.625,239.938,281.25,239.625,279.688,239.062,278.187,238.188,277.312,237.312,277.376,236.625,277.812,236.373,278.5,236.5,279.312,236.875,280.439,237.625,281.625,238.312,282.625,239.374,283.688];
fsShape[6][15] = [247.694,276.221,247.562,275.823,246.9,275.158,245.883,274.23,244.559,273.347,243.099,272.683,241.861,272.683,241.288,273.347,241.11,274.142,241.418,274.807,242.082,275.291,243.145,275.823,244.514,276.131,245.707,276.352,247.209,276.353];
fsShape[6][16] = [247.812,265.19,247.438,265.001,246.5,264.999,245.123,265.062,243.562,265.375,242.061,265.938,241.186,266.812,241.25,267.688,241.688,268.375,242.374,268.627,243.187,268.5,244.313,268.125,245.5,267.375,246.499,266.687,247.562,265.626];
fsShape[6][17] = [240.096,257.306,239.697,257.438,239.033,258.099,238.104,259.117,237.222,260.442,236.557,261.901,236.557,263.139,237.222,263.712,238.017,263.889,238.682,263.582,239.166,262.918,239.697,261.856,240.006,260.486,240.226,259.293,240.228,257.792];

fnShape[7] = 17;
fsShape[7] = new Array();
fsShape[7][0] = [270.5,270.5];
fsShape[7][1] = [272.875,255.812,271.188,256.562,269.312,257.312,267.875,257.812,266.375,258.312,268.625,258.75,271,259.438,272.25,259.812,275.062,260.125,277.25,260.25,279,260.438,276.562,258.812,274.5,257.375];
fsShape[7][2] = [267.75,259.75,266.438,261.5,265.188,262.812,264.375,262.688,263.312,262.562,262.312,263.125,260.875,264.375,260.688,262.562,259.375,259,262.562,259,265.438,259.312];
fsShape[7][3] = [259.25,263.5,257.625,264.562,256.75,265.812,254.688,268.875,252.875,271.438,254.375,272.625,255.625,274,256.5,275.438,257.625,276.688,258.25,274.625,258.688,272.875,258.625,271.75,257.438,269.688,259.5,266.125,259.375,264.562];
fsShape[7][4] = [263.438,264.188,261.625,266,260.062,268,259.188,269.125,260.312,270.5,260.875,272.125,261.312,273.625,262.438,273.812,263.5,273.688,264,273.375,263.438,271.75,264.438,270.062,265.875,268.125,265.5,266.062,265.312,264.688];
fsShape[7][5] = [266.188,269.875,265.5,270.938,264.75,271.75,265.188,273.125,265.875,274.5,266.25,275.812,267.875,275.938,270,276.438,270.562,275.562,270.625,274.438,269,274.25,268,273.938,267.312,272.688,266.562,271.25];
fsShape[7][6] = [264.562,275.062,263.125,275.438,261.938,275.312,260.25,274.625,259.25,276.875,258.375,279,257.75,281.375,260.188,280.562,262.938,280.375,265.438,280.438,268.125,280.5,269.938,280.5,271.688,279.25,270.125,277.938,269.188,277.688,265.125,277.062,264.875,275.875];
fsShape[7][7] = [271.25,276.938,272.25,277.562,273.375,278.375,274.688,276.938,276.062,275.875,277.5,274.375,276.375,273.625,274.812,273.562,273.688,273.562,272.188,274.375,271.625,275.562];
fsShape[7][8] = [263.875,281.5,265.688,283.25,267,284.688,268.25,286.438,270.438,285.812,272.688,285.188,274.312,284.25,275.375,283.5,272.688,282.875,270.438,282.188,267.625,281.75];
fsShape[7][9] = [280.375,273.312,278.75,275.188,276.438,277.312,274.188,279.312,271.875,281.188,275.312,282.188,277.875,283.25,280.5,284.812,280.812,281.688,281.062,279.562,280.938,276.562,280.875,274.875];
fsShape[7][10] = [283.438,267.125,283.25,269.688,282.562,271.25,281.875,272.625,282.25,274.938,282.312,277.125,282.188,278.938,284.188,277.938,285.625,276.812,287.375,275.625,286.688,273.812,285.875,271.5,285.25,269.375,284.562,268.25];
fsShape[7][11] = [283.438,262.312,282.438,264.25,282.062,266.625,281.812,269.062,281.062,271.062,279.062,273.062,277.875,272.625,277.125,272.375,278.438,270.75,279.375,268.875,277.875,267.375,276.5,265.312,275.25,263.312,274.188,261.438,278,261.812,280.875,262.125];
fsShape[7][12] = [277.688,269,276.938,270.312,276.062,271.75,274.625,272.188,275.438,270.375,275.312,268.75,274.188,266.5,275.312,266.25,276.25,267.25,276.875,268.125];
fsShape[7][13] = [274.625,265,273.562,265.312,272.312,264.188,270.938,263.812,269.062,264.125,267.125,265,266.625,263.625,267.938,262.062,269.812,260.375,271.812,260.875,272.938,262,274,263.5];
fsShape[7][14] = [269.5,265.312,268.562,265.438,267.062,266.312,267.25,268.5,267.438,270,268,270.5,268.125,268.438,268.688,266.75];
fsShape[7][15] = [270.25,266.375,271.25,265.125,272.25,265.562,273.312,267,273.875,268.75,272.812,270.062,271.875,270.938,272.125,268.875,271.812,267.438];
fsShape[7][16] = [274.062,270.188,273.625,271.812,272.188,273.188,270.312,273.312,269.125,273.062,268.562,271.438,270.688,272,272.062,271.938];
fsShape[7][17] = [271.125,268.938,270.875,270.625,269.938,270.938,269.062,270.375,268.875,269.25,269.562,267.5,269.812,268.938,270.438,269.25];

fnShape[8] = 12;
fsShape[8] = new Array();
fsShape[8][0] = [306.5,270.5];
fsShape[8][1] = [306.375,252.625,305.75,253.188,305.312,254.25,304.938,256.438,304.938,259.062,305.312,262.25,305.688,265.125,306,268.562,306.875,268.5,307.125,265.062,307.375,262.25,307.812,259.125,307.875,256.562,307.438,254.25,306.938,253.062];
fsShape[8][2] = [304.938,268.562,304.75,265.688,304.312,263,303.5,260.438,302.312,258.375,301,256.812,299.562,255.812,298.438,255.375,297.688,255.5,297.5,256.062,297.938,257.312,299.062,259.062,300.562,260.938,302,262.375,302.812,263.812,303.312,265.25,303.625,267.188,303.812,268.562];
fsShape[8][3] = [307.938,268.562,308.125,265.688,308.562,263,309.375,260.438,310.562,258.375,311.875,256.812,313.312,255.812,314.438,255.375,315.188,255.5,315.375,256.062,314.938,257.312,313.812,259.062,312.312,260.938,310.875,262.375,310.062,263.812,309.562,265.25,309.25,267.188,309.062,268.562];
fsShape[8][4] = [288.625,270.625,289.188,271.25,290.25,271.688,292.438,272.062,295.062,272.062,298.25,271.688,301.125,271.312,304.562,271,304.5,270.125,301.062,269.875,298.25,269.625,295.125,269.188,292.562,269.125,290.25,269.562,289.062,270.062];
fsShape[8][5] = [304.562,272.062,301.688,272.25,299,272.688,296.438,273.5,294.375,274.688,292.812,276,291.812,277.438,291.375,278.562,291.5,279.312,292.062,279.5,293.312,279.062,295.062,277.938,296.938,276.438,298.375,275,299.812,274.188,301.25,273.688,303.188,273.375,304.562,273.188];
fsShape[8][6] = [304.562,269.062,301.688,268.875,299,268.438,296.438,267.625,294.375,266.438,292.812,265.125,291.812,263.688,291.375,262.562,291.5,261.812,292.062,261.625,293.312,262.062,295.062,263.188,296.938,264.688,298.375,266.125,299.812,266.938,301.25,267.438,303.188,267.75,304.562,267.938];
fsShape[8][7] = [306.625,288.375,307.25,287.812,307.688,286.75,308.062,284.562,308.062,281.938,307.688,278.75,307.312,275.875,307,272.438,306.125,272.5,305.875,275.938,305.625,278.75,305.188,281.875,305.125,284.438,305.562,286.75,306.062,287.938];
fsShape[8][8] = [308.062,272.438,308.25,275.312,308.688,278,309.5,280.562,310.688,282.625,312,284.188,313.438,285.188,314.562,285.625,315.312,285.5,315.5,284.938,315.062,283.688,313.938,281.938,312.438,280.062,311,278.625,310.188,277.188,309.688,275.75,309.375,273.812,309.188,272.438];
fsShape[8][9] = [305.062,272.438,304.875,275.312,304.438,278,303.625,280.562,302.438,282.625,301.125,284.188,299.688,285.188,298.562,285.625,297.812,285.5,297.625,284.938,298.062,283.688,299.188,281.938,300.688,280.062,302.125,278.625,302.938,277.188,303.438,275.75,303.75,273.812,303.938,272.438];
fsShape[8][10] = [324.375,270.375,323.812,269.75,322.75,269.312,320.562,268.938,317.938,268.938,314.75,269.312,311.875,269.688,308.438,270,308.5,270.875,311.938,271.125,314.75,271.375,317.875,271.812,320.438,271.875,322.75,271.438,323.938,270.938];
fsShape[8][11] = [308.438,268.938,311.312,268.75,314,268.312,316.562,267.5,318.625,266.312,320.188,265,321.188,263.562,321.625,262.438,321.5,261.688,320.938,261.5,319.688,261.938,317.938,263.062,316.062,264.562,314.625,266,313.188,266.812,311.75,267.312,309.812,267.625,308.438,267.812];
fsShape[8][12] = [308.438,271.938,311.312,272.125,314,272.562,316.562,273.375,318.625,274.562,320.188,275.875,321.188,277.312,321.625,278.438,321.5,279.188,320.938,279.375,319.688,278.938,317.938,277.812,316.062,276.312,314.625,274.875,313.188,274.062,311.75,273.562,309.812,273.25,308.438,273.062];

fnShape[9] = 9;
fsShape[9] = new Array();
fsShape[9][0] = [342.5,270.5];
fsShape[9][1] = [347.235,268.893,346.832,268.005,346.329,267.241,345.732,266.613,345.006,266.12,344.165,265.691,343.421,265.479,342.741,265.389,341.869,265.394,341.131,265.55,340.221,265.874,339.494,266.33,338.752,266.91,338.169,267.634,337.778,268.331,337.466,269.107,337.294,269.978,337.284,270.802,337.417,271.742,337.697,272.525,338.221,273.427,338.883,274.169,339.585,274.76,340.479,275.262,341.339,275.487,342.258,275.612,343.182,275.51,344.116,275.262,344.977,274.871,345.775,274.3,346.375,273.709,346.812,273.062,347.12,272.453,347.367,271.641,347.488,270.896,347.482,270.164,347.414,269.538];
fsShape[9][2] = [342.562,253.688,341.75,254.75,341.125,255.75,340.75,256.812,340.5,258.188,340.188,259.5,339.625,259,338.875,258.625,338.812,259.688,339.312,261.125,340.25,263.25,341.75,262.938,343.562,263,344.812,263.312,345.625,261.5,346.25,260.062,346.375,258.562,345.562,258.875,344.938,259.438,344.5,257.75,344.188,256.125,343.688,255.062,343.125,254.25];
fsShape[9][3] = [330.619,258.479,330.795,259.805,331.061,260.954,331.547,261.971,332.342,263.12,333.05,264.269,332.299,264.313,331.503,264.578,332.209,265.374,333.58,266.036,335.745,266.876,336.585,265.595,337.91,264.357,339.016,263.694,338.309,261.838,337.734,260.379,336.762,259.23,336.408,260.026,336.363,260.866,334.861,259.982,333.491,259.054,332.387,258.656,331.414,258.479];
fsShape[9][4] = [325.562,270.312,326.624,271.126,327.624,271.751,328.688,272.125,330.062,272.376,331.374,272.688,330.875,273.25,330.5,274,331.562,274.063,332.999,273.562,335.123,272.625,334.812,271.125,334.873,269.313,335.188,268.063,333.374,267.25,331.937,266.625,330.437,266.5,330.749,267.312,331.312,267.938,329.625,268.375,327.999,268.688,326.938,269.188,326.123,269.75];
fsShape[9][5] = [330.354,282.256,331.68,282.08,332.828,281.815,333.846,281.328,334.994,280.533,336.143,279.826,336.188,280.576,336.453,281.372,337.248,280.666,337.91,279.295,338.75,277.131,337.469,276.29,336.23,274.965,335.568,273.859,333.712,274.566,332.254,275.141,331.104,276.113,331.9,276.467,332.74,276.512,331.857,278.013,330.928,279.384,330.531,280.488,330.353,281.462];
fsShape[9][6] = [342.188,287.313,343,286.251,343.625,285.251,344,284.188,344.25,282.813,344.562,281.501,345.124,282,345.875,282.375,345.938,281.313,345.437,279.876,344.5,277.752,343,278.063,341.188,278.002,339.937,277.688,339.124,279.501,338.5,280.938,338.374,282.438,339.188,282.126,339.812,281.563,340.25,283.25,340.562,284.876,341.062,285.938,341.625,286.752];
fsShape[9][7] = [354.131,282.521,353.954,281.195,353.689,280.047,353.202,279.029,352.407,277.881,351.7,276.732,352.45,276.688,353.246,276.422,352.54,275.627,351.169,274.965,349.005,274.125,348.164,275.406,346.84,276.645,345.733,277.308,346.44,279.163,347.016,280.621,347.987,281.771,348.342,280.975,348.386,280.135,349.887,281.018,351.259,281.947,352.362,282.344,353.336,282.523];
fsShape[9][8] = [359.188,270.688,358.125,269.875,357.126,269.25,356.062,268.875,354.688,268.625,353.375,268.313,353.874,267.751,354.249,267,353.188,266.938,351.75,267.438,349.626,268.375,349.938,269.875,349.877,271.688,349.562,272.939,351.375,273.751,352.812,274.375,354.312,274.501,354,273.688,353.438,273.062,355.123,272.625,356.751,272.312,357.812,271.812,358.627,271.251];
fsShape[9][9] = [354.396,258.744,353.069,258.921,351.921,259.186,350.903,259.673,349.755,260.468,348.605,261.175,348.562,260.425,348.296,259.629,347.501,260.335,346.839,261.706,345.999,263.87,347.28,264.711,348.52,266.035,349.182,267.143,351.037,266.435,352.495,265.859,353.645,264.888,352.849,264.534,352.009,264.489,352.893,262.989,353.821,261.616,354.218,260.513,354.397,259.539];

fnShape[10] = 9;
fsShape[10] = new Array();
fsShape[10][0] = [378.5,270.5];
fsShape[10][1] = [385.738,268.083,385.126,266.738,384.364,265.58,383.459,264.627,382.357,263.88,381.083,263.23,379.955,262.909,378.925,262.772,377.603,262.78,376.483,263.017,375.104,263.507,374.002,264.199,372.877,265.078,371.993,266.176,371.4,267.232,370.927,268.41,370.666,269.729,370.651,270.979,370.853,272.404,371.277,273.59,372.071,274.958,373.075,276.083,374.14,276.979,375.496,277.74,376.799,278.081,378.191,278.271,379.592,278.116,381.009,277.74,382.313,277.146,383.524,276.281,384.434,275.386,385.097,274.406,385.563,273.481,385.938,272.25,386.121,271.121,386.112,270.011,386.009,269.062];
fsShape[10][2] = [378.438,255.312,378.562,259.188,377.25,259.312,376.062,259.5,374.75,259.875,373.688,260.312,372.938,260.688,370.938,257.312,372.625,256.5,374.375,255.812,376.188,255.438];
fsShape[10][3] = [367.636,259.735,370.464,262.387,369.624,263.403,368.917,264.376,368.254,265.569,367.812,266.629,367.547,267.425,363.746,266.453,364.365,264.685,365.116,262.962,366.133,261.415];
fsShape[10][4] = [363.125,270.501,367,270.375,367.124,271.688,367.312,272.876,367.687,274.188,368.125,275.25,368.499,276.001,365.125,278.001,364.312,276.313,363.625,274.564,363.25,272.751];
fsShape[10][5] = [367.548,281.303,370.199,278.474,371.215,279.315,372.188,280.021,373.381,280.685,374.441,281.125,375.236,281.392,374.266,285.192,372.497,284.573,370.774,283.822,369.227,282.805];
fsShape[10][6] = [378.313,285.813,378.188,281.938,379.5,281.815,380.688,281.626,382,281.251,383.062,280.813,383.812,280.44,385.813,283.813,384.125,284.626,382.376,285.313,380.562,285.688];
fsShape[10][7] = [389.115,281.391,386.286,278.739,387.127,277.724,387.834,276.75,388.496,275.558,388.938,274.497,389.203,273.703,393.004,274.673,392.385,276.442,391.635,278.165,390.617,279.712];
fsShape[10][8] = [393.626,270.625,389.75,270.75,389.627,269.438,389.438,268.25,389.063,266.938,388.625,265.876,388.252,265.126,391.625,263.125,392.438,264.814,393.126,266.562,393.501,268.376];
fsShape[10][9] = [389.203,259.823,386.551,262.652,385.536,261.812,384.562,261.104,383.37,260.442,382.309,260.001,381.515,259.735,382.484,255.935,384.254,256.554,385.977,257.304,387.524,258.321];

fnShape[11] = 5;
fsShape[11] = new Array();
fsShape[11][0] = [414.5,270.5];
fsShape[11][1] = [414.5,252.875,414,253.062,413.812,253.438,413.75,254.188,413.75,266.625,413.5,267.688,413.062,268.438,412.438,269.188,411.625,269.5,410.75,269.688,397.812,269.688,397.062,269.938,396.812,270.375,397.062,270.938,397.688,271.188,411.125,271.25,412.125,271.562,412.812,272.125,413.375,272.875,413.625,273.688,413.688,274.5,413.688,287.25,413.875,287.938,414.5,288.188,414.938,288.062,415.25,287.438,415.25,274.312,415.438,273.125,416.062,272.312,416.75,271.688,417.625,271.312,418.5,271.188,431.375,271.25,432.062,270.812,432.125,270.312,431.875,269.875,431.312,269.75,430.75,269.688,418.25,269.688,417.312,269.5,416.562,269.125,415.875,268.438,415.438,267.625,415.25,266.875,415.25,266.25,415.25,254.125,415.188,253.312,414.938,252.938];
fsShape[11][2] = [412.062,257,411.938,256.062,411.438,255.125,410.688,254.438,409.875,253.875,408.875,253.75,407.938,253.75,407.062,254.188,406.25,254.812,405.688,255.688,405.312,256.75,405.438,257.875,405.875,258.75,406.5,259.562,407.5,260.188,408.5,260.375,409.125,260.312,409.438,259.812,409.438,259.312,409,259,408.625,258.938,407.938,258.688,407.375,258.25,407,257.625,406.938,256.875,407.25,256.062,407.812,255.562,408.625,255.25,409.312,255.375,410,255.812,410.438,256.438,410.562,257.062,410.562,257.562,410.562,264.5,410.375,265.375,410.062,265.875,409.625,266.312,408.812,266.562,401.062,266.562,400.25,266.312,399.75,265.875,399.375,265.062,399.5,264.125,400.062,263.312,400.938,262.938,401.75,263,402.438,263.312,402.938,263.938,403.125,264.625,403.312,265.25,403.812,265.438,404.312,265.188,404.5,264.562,404.375,263.75,404,262.875,403.438,262.188,402.625,261.75,401.812,261.438,400.812,261.375,399.812,261.688,398.875,262.312,398.312,263.188,397.938,264.125,397.875,265.125,398.25,266.125,398.812,267,399.688,267.625,400.688,268,401.375,268,408.938,268,409.938,267.812,410.812,267.312,411.438,266.625,411.938,265.875,412.062,265];
fsShape[11][3] = [401.094,272.969,400.156,273.094,399.219,273.594,398.531,274.344,397.969,275.156,397.844,276.156,397.844,277.094,398.281,277.969,398.906,278.781,399.781,279.344,400.844,279.719,401.969,279.594,402.844,279.156,403.656,278.531,404.281,277.531,404.469,276.531,404.406,275.906,403.906,275.594,403.406,275.594,403.094,276.031,403.031,276.406,402.781,277.094,402.344,277.656,401.719,278.031,400.969,278.094,400.156,277.781,399.656,277.219,399.344,276.406,399.469,275.719,399.906,275.031,400.531,274.594,401.156,274.469,401.656,274.469,408.594,274.469,409.469,274.656,409.969,274.969,410.406,275.406,410.656,276.219,410.656,283.969,410.406,284.781,409.969,285.281,409.156,285.656,408.219,285.531,407.406,284.969,407.031,284.094,407.094,283.281,407.406,282.594,408.031,282.094,408.719,281.906,409.344,281.719,409.531,281.219,409.281,280.719,408.656,280.531,407.844,280.656,406.969,281.031,406.281,281.594,405.844,282.406,405.531,283.219,405.469,284.219,405.781,285.219,406.406,286.156,407.281,286.719,408.219,287.094,409.219,287.156,410.219,286.781,411.094,286.219,411.719,285.344,412.094,284.344,412.094,283.656,412.094,276.094,411.906,275.094,411.406,274.219,410.719,273.594,409.969,273.094,409.094,272.969];
fsShape[11][4] = [417.062,283.906,417.188,284.844,417.688,285.781,418.438,286.469,419.25,287.031,420.25,287.156,421.188,287.156,422.062,286.719,422.875,286.094,423.438,285.219,423.812,284.156,423.688,283.031,423.25,282.156,422.625,281.344,421.625,280.719,420.625,280.531,420,280.594,419.688,281.094,419.688,281.594,420.125,281.906,420.5,281.969,421.188,282.219,421.75,282.656,422.125,283.281,422.188,284.031,421.875,284.844,421.312,285.344,420.5,285.656,419.812,285.531,419.125,285.094,418.688,284.469,418.562,283.844,418.562,283.344,418.562,276.406,418.75,275.531,419.062,275.031,419.5,274.594,420.312,274.344,428.062,274.344,428.875,274.594,429.375,275.031,429.75,275.844,429.625,276.781,429.062,277.594,428.188,277.969,427.375,277.906,426.688,277.594,426.188,276.969,426,276.281,425.812,275.656,425.312,275.469,424.812,275.719,424.625,276.344,424.75,277.156,425.125,278.031,425.688,278.719,426.5,279.156,427.312,279.469,428.312,279.531,429.312,279.219,430.25,278.594,430.812,277.719,431.188,276.781,431.25,275.781,430.875,274.781,430.312,273.906,429.438,273.281,428.438,272.906,427.75,272.906,420.188,272.906,419.188,273.094,418.312,273.594,417.688,274.281,417.188,275.031,417.062,275.906];
fsShape[11][5] = [428.031,267.938,428.969,267.812,429.906,267.312,430.594,266.562,431.156,265.75,431.281,264.75,431.281,263.812,430.844,262.938,430.219,262.125,429.344,261.562,428.281,261.188,427.156,261.312,426.281,261.75,425.469,262.375,424.844,263.375,424.656,264.375,424.719,265,425.219,265.312,425.719,265.312,426.031,264.875,426.094,264.5,426.344,263.812,426.781,263.25,427.406,262.875,428.156,262.812,428.969,263.125,429.469,263.688,429.781,264.5,429.656,265.188,429.219,265.875,428.594,266.312,427.969,266.438,427.469,266.438,420.531,266.438,419.656,266.25,419.156,265.938,418.719,265.5,418.469,264.688,418.469,256.938,418.719,256.125,419.156,255.625,419.969,255.25,420.906,255.375,421.719,255.938,422.094,256.812,422.031,257.625,421.719,258.312,421.094,258.812,420.406,259,419.781,259.188,419.594,259.688,419.844,260.188,420.469,260.375,421.281,260.25,422.156,259.875,422.844,259.312,423.281,258.5,423.594,257.688,423.656,256.688,423.344,255.688,422.719,254.75,421.844,254.188,420.906,253.812,419.906,253.75,418.906,254.125,418.031,254.688,417.406,255.562,417.031,256.562,417.031,257.25,417.031,264.812,417.219,265.812,417.719,266.688,418.406,267.312,419.156,267.812,420.031,267.938];

fnShape[12] = 1;
fsShape[12] = new Array();
fsShape[12][0] = [450.5,270.5];
fsShape[12][1] = [450.5,252.875,448.125,268.125,432.875,270.438,448.125,272.812,450.562,288.312,452.875,272.812,468,270.438,452.812,268];

fnShape[13] = 1;
fsShape[13] = new Array();
fsShape[13][0] = [486.5,270.5];
fsShape[13][1] = [486.438,254.062,485,266.875,475.062,258.938,482.938,268.875,470.375,270.375,482.875,271.812,474.938,281.938,485,274,486.562,286.75,488,273.938,498,281.938,490.188,271.938,502.625,270.375,490.062,268.875,497.938,258.938,488,266.875];

fnShape[14] = 11;
fsShape[14] = new Array();
fsShape[14][0] = [522.5,270.5];
fsShape[14][1] = [523.688,269,524.062,266,524.125,264,523.812,262,523.25,261,522.625,260.688,522,260.812,521.5,261.5,521.125,262.625,520.938,264.25,521,265.812,521.125,267.25,521.375,268.875,519.812,267.938,518.312,267.312,516.562,266.812,514.938,266.625,513.812,266.812,513.188,267.25,513.188,267.812,513.812,268.75,515,269.5,516.625,270.125,518.312,270.562,519.75,270.938,520.625,271,519.312,272.188,518.125,273.625,517.062,275.125,516.5,276.438,516.312,277.375,516.5,278.062,517,278.438,518,278.188,518.875,277.562,519.875,276.5,520.812,275.375,521.625,273.938,522.312,272.438,523.125,274.062,524.25,275.75,525.188,277,526.312,277.938,527.25,278.5,528.125,278.5,528.438,278.062,528.438,277.125,528.125,276.062,527.312,274.625,526.188,273.125,525.188,272.062,524.25,271.188,526.188,270.875,527.812,270.5,529.438,270,530.438,269.438,531.188,268.75,531.812,267.938,531.688,267.375,531.25,267,530.5,266.812,529.5,266.875,528.062,267.125,526.438,267.688,525,268.25];
fsShape[14][2] = [529.312,261.188,528.312,259.75,527.188,258.562,525.688,257.688,524.25,257.125,522.875,257,521.438,257.062,520.062,257.375,518.625,258.062,517.375,259,516.562,259.938,515.875,261.062,515.938,259.312,516.688,257.438,517.812,256,519.25,254.938,521.188,254.188,522.812,254.062,524.375,254.312,525.875,254.938,527.125,255.938,528.125,257.062,528.875,258.438,529.188,259.75];
fsShape[14][3] = [516.438,255.375,515.625,256.5,515,257.938,514.688,259.438,513.312,259.188,511.688,259.188,510,259.625,510.812,257.75,512.062,256.5,513.562,255.562,514.938,255.312];
fsShape[14][4] = [515.791,261.203,514.115,261.71,512.638,262.413,511.342,263.569,510.363,264.762,509.819,266.031,509.435,267.418,509.307,268.822,509.516,270.401,510.021,271.88,510.662,272.942,511.52,273.944,509.875,273.344,508.323,272.051,507.304,270.537,506.737,268.841,506.623,266.767,507.006,265.183,507.727,263.774,508.785,262.541,510.121,261.661,511.501,261.058,513.041,260.769,514.385,260.877];
fsShape[14][5] = [506.284,271.651,507.104,272.771,508.277,273.811,509.607,274.571,508.945,275.802,508.442,277.347,508.337,279.087,506.805,277.735,506.002,276.16,505.574,274.443,505.762,273.059];
fsShape[14][6] = [511.627,274.067,511.592,275.818,511.803,277.439,512.503,279.03,513.335,280.329,514.374,281.238,515.574,282.033,516.87,282.589,518.437,282.878,519.998,282.854,521.207,282.572,522.425,282.066,521.346,283.445,519.637,284.521,517.881,285.023,516.094,285.038,514.086,284.506,512.697,283.652,511.58,282.531,510.734,281.144,510.311,279.601,510.163,278.103,510.365,276.549,510.883,275.304];
fsShape[14][7] = [518.627,286.338,519.945,285.904,521.296,285.109,522.431,284.079,523.396,285.089,524.71,286.045,526.332,286.683,524.574,287.723,522.827,287.999,521.062,287.875,519.803,287.269];
fsShape[14][8] = [522.575,282.003,524.229,282.577,525.837,282.878,527.566,282.703,529.059,282.313,530.244,281.606,531.371,280.71,532.3,279.649,533.059,278.249,533.518,276.756,533.625,275.52,533.52,274.205,534.497,275.657,534.992,277.615,534.928,279.44,534.39,281.145,533.263,282.89,532.021,283.946,530.61,284.663,529.029,285.038,527.432,284.965,525.961,284.642,524.545,283.97,523.521,283.093];
fsShape[14][9] = [536.408,279.137,536.403,277.749,536.064,276.219,535.436,274.821,536.694,274.215,538.01,273.262,539.117,271.916,539.562,273.909,539.286,275.656,538.623,277.296,537.657,278.307];
fsShape[14][10] = [533.506,274.043,534.562,272.646,535.346,271.211,535.714,269.512,535.805,267.972,535.498,266.626,534.994,265.277,534.272,264.066,533.175,262.912,531.897,262.014,530.754,261.53,529.471,261.225,531.154,260.743,533.17,260.877,534.886,261.503,536.34,262.541,537.651,264.152,538.273,265.659,538.518,267.223,538.387,268.842,537.823,270.339,537.062,271.638,535.985,272.777,534.835,273.479];
fsShape[14][11] = [535.055,260.001,533.732,259.577,532.173,259.426,530.649,259.593,530.462,258.208,529.962,256.662,529.023,255.193,531.058,255.386,532.634,256.188,533.988,257.325,534.65,258.557];

fnShape[15] = 1;
fsShape[15] = new Array();
fsShape[15][0] = [558.5,270.5];
fsShape[15][1] = [553.625,265.625,552,265.875,550.125,266.25,548.188,266.75,546.688,267.312,545.375,268.062,544.25,268.875,543.688,269.75,543.438,270.625,543.812,271.625,544.812,272.5,546.5,273.5,548.25,274.188,549.938,274.688,551.625,275,553.688,275.312,554,277.688,554.438,279.625,555.125,281.625,555.938,283.438,556.938,284.875,558.062,285.5,559,285.438,560.375,284.562,561.375,283,562.125,281.062,562.688,279.125,563.062,277.312,563.312,275.375,565.562,275.062,568.062,274.438,570,273.812,571.25,273.188,572.312,272.5,573.188,271.438,573.562,270.625,573.375,269.75,572.812,268.938,571.938,268.188,570.812,267.562,569.25,266.875,567.625,266.375,565.75,265.938,564.5,265.75,563.375,265.688,563.188,263.75,562.75,262,562.25,260.25,561.688,258.812,561,257.562,560.25,256.375,559.375,255.688,558.625,255.438,557.875,255.562,557.125,255.938,556.25,256.812,555.5,258.125,554.875,259.688,554.312,261.562,554,263.125,553.812,264.188];

fnShape[16] = 1;
fsShape[16] = new Array();
fsShape[16][0] = [594.5,270.5];
fsShape[16][1] = [590,256.938,590,265.875,581.062,265.938,581.062,274.938,590.062,275,590,283.875,599.062,283.875,599.062,275,607.875,274.938,607.938,266,599,265.938,599.062,257];

// heart
fnShape[17] = 1;
fsShape[17] = new Array();
fsShape[17][0] = [190.697,277.562];
fsShape[17][1] = [190.785,292.287,193.682,289.671,196.976,286.668,
	199.591,284.247,201.169,282.553,202.594,280.759,203.466,278.918,203.756,277.078,203.66,275.237,202.981,273.396,201.818,271.943,
	200.463,270.975,198.622,270.296,197.008,270.126,195.507,270.165,194.291,270.412,193.056,270.887,192.068,271.551,
	191.365,272.331,190.785,273.105,190.205,272.331,189.501,271.551,188.514,270.887,187.278,270.412,186.063,270.165,
	184.562,270.126,182.947,270.296,181.106,270.975,179.75,271.943,178.588,273.396,177.91,275.237,177.813,277.078,178.104,278.918,
	178.975,280.759,180.4,282.553,181.979,284.247,184.594,286.668,187.888,289.671];

//star
fnShape[18] = 1;
fsShape[18] = new Array();
fsShape[18][0] = [190.697,277.562];
fsShape[18][1] = [190.697,261.806,195.328,271.188,205.683,272.693,
		198.19,279.997,199.958,290.309,190.697,285.44,181.436,290.309,183.205,279.997,175.712,272.693,186.066,271.188];

//snow
fnShape[19] = 1;
fsShape[19] = new Array();
fsShape[19][0] = [190.5,278.875];
fsShape[19][1] = [202.578,285.677,205.147,284.307,204.956,283.64,201.966,285.022,201.263,284.539,203.759,282.932,
		203.4,282.06,200.049,283.838,199.145,283.315,203.64,280.604,203.012,279.577,197.94,282.622,197.115,282.144,200.358,280.189,
		199.839,279.23,195.944,281.469,195.404,281.156,196.959,280.039,196.474,279.361,194.458,280.61,193.288,279.934,193.281,279.545,
		193.306,279.53,193.282,278.208,194.465,277.526,196.469,278.79,196.965,278.098,195.409,276.98,195.95,276.668,199.864,278.906,
		200.364,277.948,197.121,275.992,197.946,275.516,203.019,278.559,203.646,277.532,199.15,274.821,200.056,274.298,
		203.406,276.077,203.765,275.205,201.269,273.598,201.976,273.115,204.962,274.496,205.153,273.828,202.603,272.465,
		205.918,270.208,202.283,271.938,202.381,269.027,201.707,268.859,201.41,272.139,200.64,272.507,200.496,269.542,199.561,269.417,
		199.426,273.208,198.521,273.73,198.421,268.481,197.217,268.511,197.317,274.426,196.491,274.902,196.42,271.116,195.33,271.085,
		195.321,275.578,194.78,275.89,194.59,273.984,193.761,274.065,193.835,276.436,192.664,277.111,192.323,276.923,192.323,276.894,
		191.167,276.253,191.167,274.888,193.264,273.784,192.913,273.008,191.167,273.797,191.167,273.172,195.061,270.902,
		194.481,269.99,191.167,271.82,191.167,270.867,196.338,267.997,195.762,266.94,191.167,269.478,191.167,268.432,194.382,266.42,
		193.807,265.672,191.167,267.031,191.103,266.178,193.791,264.283,193.309,263.784,190.853,265.31,190.556,261.31,190.236,265.323,
		187.764,263.783,187.283,264.283,189.974,266.18,189.908,267.031,187.268,265.672,186.693,266.42,189.908,268.432,189.908,269.478,
		185.312,266.94,184.736,267.997,189.908,270.867,189.908,271.82,186.593,269.99,186.021,270.918,189.908,273.172,189.908,273.797,
		188.162,273.008,187.818,273.768,189.908,274.888,189.908,276.241,189.574,276.441,189.548,276.427,188.415,277.108,
		187.233,276.425,187.326,274.057,186.479,273.973,186.288,275.879,185.748,275.567,185.728,271.06,184.649,271.105,
		184.577,274.892,183.751,274.415,183.852,268.501,182.647,268.471,182.548,273.72,181.642,273.197,181.507,269.407,
		180.572,269.531,180.429,272.497,179.658,272.125,179.361,268.85,178.687,269.018,178.782,271.907,175.169,270.165,
		178.484,272.449,175.915,273.819,176.107,274.486,179.096,273.104,179.799,273.587,177.303,275.194,177.663,276.065,
		181.013,274.288,181.918,274.81,177.422,277.521,178.05,278.549,183.122,275.505,183.947,275.982,180.705,277.937,181.223,278.896,
		185.118,276.658,185.659,276.97,184.103,278.087,184.589,278.765,186.604,277.516,187.775,278.192,187.782,278.582,
		187.757,278.596,187.78,279.917,186.598,280.6,184.593,279.336,184.097,280.028,185.653,281.146,185.112,281.458,181.198,279.221,
		180.698,280.178,183.941,282.134,183.116,282.61,178.044,279.567,177.417,280.594,181.913,283.305,181.006,283.828,177.656,282.05,
		177.297,282.922,179.793,284.529,179.086,285.011,176.101,283.63,175.91,284.297,178.459,285.66,175.145,287.918,178.779,286.189,
		178.682,289.099,179.355,289.267,179.653,285.987,180.423,285.619,180.566,288.584,181.501,288.709,181.636,284.918,
		182.542,284.396,182.642,289.645,183.846,289.615,183.745,283.701,184.571,283.224,184.643,287.01,185.732,287.041,
		185.741,282.548,186.282,282.236,186.472,284.142,187.302,284.061,187.227,281.69,188.399,281.015,188.739,281.203,188.74,281.232,
		189.896,281.873,189.896,283.238,187.799,284.342,188.15,285.118,189.896,284.329,189.896,284.954,186.001,287.224,
		186.581,288.136,189.896,286.306,189.896,287.258,184.724,290.129,185.3,291.186,189.896,288.648,189.896,289.694,186.68,291.707,
		187.256,292.454,189.896,291.095,189.959,291.948,187.271,293.844,187.754,294.343,190.208,292.816,190.506,296.816,
		190.826,292.803,193.298,294.343,193.78,293.843,191.088,291.946,191.155,291.095,193.794,292.453,194.37,291.706,191.155,289.694,
		191.155,288.648,195.751,291.186,196.326,290.129,191.154,287.259,191.155,286.306,194.469,288.136,195.041,287.208,
		191.154,284.954,191.155,284.329,192.9,285.118,193.244,284.358,191.155,283.238,191.155,281.885,191.489,281.685,191.514,281.699,
		192.646,281.018,193.829,281.701,193.736,284.069,194.584,284.153,194.774,282.247,195.315,282.559,195.334,287.067,
		196.414,287.021,196.485,283.234,197.311,283.711,197.211,289.625,198.415,289.655,198.515,284.406,199.42,284.929,199.555,288.72,
		200.49,288.595,200.633,285.629,201.405,286.001,201.702,289.277,202.375,289.108,202.28,286.219,205.893,287.961];



//cat
fnShape[20] = 5;
fsShape[20] = new Array();
fsShape[20][0] = [223.333,278.208];
fsShape[20][1] = [216.045,287.639,215.858,286.718,215.914,285.401,216.284,284.481,216.945,283.318,
		218.007,282.404,219.27,281.379,219.879,280.362,220.543,279.479,221.573,278.864,222.725,278.473,224.382,278.623,
		225.458,279.083,226.049,280.194,226.378,281.255,227.212,282.286,228.38,283.028,229.362,283.646,230.151,284.48,230.422,285.358,
		230.422,286.17,230.252,287.529,230.021,288.626,229.362,289.115,228.419,289.46,227.3,289.382,226.093,289.131,225.388,288.677,
		224.535,288.188,223.529,287.983,222.385,287.947,221.616,288.229,221.155,288.526,220.367,289.087,219.533,289.373,
		218.743,289.468,217.668,289.197,216.807,288.498];
fsShape[20][2] = [216.197,280.445,215.719,280.148,215.116,279.432,214.782,278.353,214.577,276.861,
		214.677,275.211,215.115,274.099,215.655,273.177,216.282,272.896,217.072,272.887,217.703,273.591,218.072,274.741,
		218.274,276.763,218.161,278.133,217.775,279.092,217.104,280.009,216.709,280.322];
fsShape[20][3] = [219.924,273.629,219.455,272.709,219.171,271.502,219.126,270.274,219.236,269.287,219.709,267.96,
		220.158,267.07,220.81,266.49,221.519,266.391,222.264,266.873,222.747,267.729,222.912,269.176,222.831,270.566,222.681,271.942,
		222.359,273.08,221.759,273.829,221.035,274.157,220.335,273.937];
fsShape[20][4] = [225.391,274.016,225.105,273.27,224.952,271.975,225.031,270.399,225.232,268.814,225.544,267.434,
		226.05,266.6,226.767,266.226,227.585,266.292,228.375,267.258,228.748,268.399,228.644,269.846,228.437,271.481,227.979,272.918,
		227.387,273.971,226.883,274.454,226.244,274.74,225.794,274.458];
fsShape[20][5] = [229.5,278.645,229.401,277.789,229.401,276.745,229.676,274.586,230.041,272.957,230.422,272.282,
		230.794,272.006,231.388,271.888,232.046,272.131,232.726,272.853,232.918,274.234,232.945,276.231,232.572,277.624,
		232.046,278.732,231.355,279.264,230.579,279.729,229.917,279.303];
        
        
var curlTotal = 0;

var frameNum = 1;

function StartEachRender (api)
{
    ////Engine.message ("starting render " + frameNum)
     frameNum++
 }

function EndEachRender (api)
{
   // alert("end render")
}

//Engine.setParameter(kIncrementalRender, 0)
//RenderAPI.setParameter(kIncrementalRender, 0)

function ModuleCurl (parameters, generation, pType, sColor, cColorFade, curveVisible, angle, x, y, side, sSize, ipWidth, pWidth, spiral, sCircle, sCircleSize, sCircleSizeRatio, sCircleSizeRandom, scColor, tail, boxRatio, progressRatio, flip, leaves, sLeaves, slPoints, cContinuous, objAngleSnap, cGenerationN, cgSizeRatio, cgSizeRandom, offsetX, offsetY)
{
    this.offsetX = offsetX;
    this.offsetY = offsetY;
    
    this.parameters = parameters;

    this.generation = generation;
    
    this.pType = pType;
    this.pWidth = pWidth;
    this.ipWidth = ipWidth;
    
    this.angle = angle;
    
    this.pr = progressRatio;      // need this when stopping overlap
    this.flip = flip;                   // need this to check if it is flip mode to stop overlapping
        
    this.x = x;
    this.y = y;
    this.x1 = x;
    this.y1 = y;
    this.width = ipWidth;
    this.spiral = spiral;
    this.sCircle = sCircle;
    this.sCircleSize = sCircleSize;
    this.sCircleSizeRatio = sCircleSizeRatio;
    this.sCircleSizeRandom = sCircleSizeRandom;
    this.scColor = scColor;
    
    this.tail = tail;
    this.sColor = sColor;
    this.cColorFade = cColorFade;
    this.curveVisible = curveVisible;

    this.cGenerationN = cGenerationN;
    this.cgSizeRatio = cgSizeRatio;
    this.cgSizeRandom = cgSizeRandom;





    this.cContinuous = cContinuous;

    this.spiralSize = sSize;
    this.side = side;
    
    this.step = 0;
    this.child = 0;
    this.boxRatio = boxRatio;
  
    this.leaves = leaves;
    this.sLeaves = sLeaves;
    this.slPoints = slPoints;
    
    this.objAngleSnap = objAngleSnap;
    
    this.finish = false;
    

    
    this.pointsA = new Array;  // points of one side
    this.pointsB = new Array;  // points of another side
    this.pointsC = new Array;  // points of small circles for end of the patterns

    this.pointsF = new Array;
    for (var i = 0; i < 17; i++){
        this.pointsF[i] = new Array();
    }
}


ModuleCurl.prototype.produce = function (system)
{
    curlTotal++;
    
    if(this.finish){
//        Engine.removeModule(this);
//        Engine.setModuleParameter (this, "call", "render", 0)

        return kDontCallAgain;
    }else{
        for(this.step = 0; this.step < this.spiral; this.step++){

            this.x1 = this.x;
            this.y1 = this.y;

            if(this.side == 1)
                this.angle -= 0.04 + this.step*this.step/10000;
            else
                this.angle += 0.04 + this.step*this.step/10000;
            this.x += Math.cos(this.angle)*this.spiralSize;
            this.y += Math.sin(this.angle)*this.spiralSize;
            
            switch (this.pType)
            {
                case 0:
                    break;
                case 1:
                    this.width += 0.01 * this.pWidth;
                    break;
                case 2:
                    this.width -= 0.01 * this.pWidth;
                    break;
                case 3:
                    if (this.step < 28)
                        this.width += (this.step/250) * this.pWidth;
                    else
                        this.width -= (Math.pow(this.step-28,3)/500) * this.pWidth;
                    break;
                case 4:
                    if (this.step < 28)
                        this.width -= (this.step/100) * this.pWidth;
                    else
                        this.width += (Math.pow(this.step-28,2)/5000) * this.pWidth;
                    break;
                case 5:
                    this.width = this.ipWidth + Math.cos(this.step/2)* this.pWidth;
                    break;
                case 6:
                    this.width = this.ipWidth + Engine.rand()*this.pWidth;
                    break;
            }
            if (this.width < 0.5)
                this.width = 0.5;

            if (((this.cContinuous!=0 && (this.step == this.spiral -1) && (total > 0))) || ((this.cContinuous==0 && total > 0 && Engine.rand() < 0.2 && this.step < 100 && this.step > 3 && this.child < 1 && this.generation < this.cGenerationN))){

                this.generation++;

                var nextOpacity = this.cColorFade;
                if ( this.cColorFade < 1)
                    nextOpacity *= this.cColorFade;
                    
                if (this.cContinuous>0){
                    this.cContinuous--;
                    if (this.cContinuous == 1){
                        Engine.addModule(new ModuleCurl(this.parameters, this.generation, this.pType, this.sColor, nextOpacity, this.curveVisible, this.angle, this.x, this.y, 1-this.side,this.spiralSize + (this.spiralSize*this.cgSizeRatio*this.generation)+ (0.5+Engine.rand()*this.cgSizeRandom), this.width, this.pWidth, this.spiral + this.tail, this.sCircle, this.sCircleSize, this.sCircleSizeRatio, this.sCircleSizeRandom, this.scColor, this.tail, this.boxRatio, this.pr , this.flip, this.leaves, this.sLeaves, this.slPoints, this.cContinuous, this.objAngleSnap, this.cGenerationN, this.cgSizeRatio, this.cgSizeRandom, offsetX, offsetY));
                    }else if (this.cContinuous >1){
                        Engine.addModule(new ModuleCurl(this.parameters, this.generation, this.pType, this.sColor, nextOpacity, this.curveVisible, this.angle, this.x, this.y, 1-this.side,this.spiralSize + (this.spiralSize*this.cgSizeRatio*this.generation)+ (0.5+Engine.rand()*this.cgSizeRandom), this.width, this.pWidth, this.spiral, this.sCircle, this.sCircleSize, this.sCircleSizeRatio, this.sCircleSizeRandom, this.scColor, this.tail, this.boxRatio, this.pr , this.flip, this.leaves, this.sLeaves, this.slPoints, this.cContinuous, this.objAngleSnap, this.cGenerationN, this.cgSizeRatio, this.cgSizeRandom, offsetX, offsetY));
                    }
                    total--;
                    this.child++;
                }
                else if (this.cContinuous< 0){

                    this.cContinuous++;
                    if (this.cContinuous == -1){
                        Engine.addModule(new ModuleCurl(this.parameters, this.generation, this.pType, this.sColor, nextOpacity, this.curveVisible, this.angle, this.x, this.y, 1-this.side,this.spiralSize + (this.spiralSize*this.cgSizeRatio*this.generation)+ (0.5+Engine.rand()*this.cgSizeRandom), this.width, this.pWidth, this.spiral + this.tail, this.sCircle, this.sCircleSize, this.sCircleSizeRatio, this.sCircleSizeRandom, this.scColor, this.tail, this.boxRatio, this.pr , this.flip, this.leaves, this.sLeaves, this.slPoints, 1, this.objAngleSnap, this.cGenerationN, this.cgSizeRatio, this.cgSizeRandom, offsetX, offsetY));
                    }else if (this.cContinuous < -1){
                        Engine.addModule(new ModuleCurl(this.parameters, this.generation, this.pType, this.sColor, nextOpacity, this.curveVisible, this.angle, this.x, this.y, 1-this.side,this.spiralSize + (this.spiralSize*this.cgSizeRatio*this.generation)+ (0.5+Engine.rand()*this.cgSizeRandom), this.width, this.pWidth, this.spiral, this.sCircle, this.sCircleSize, this.sCircleSizeRatio, this.sCircleSizeRandom, this.scColor, this.tail, this.boxRatio, this.pr , this.flip, this.leaves, this.sLeaves, this.slPoints, this.cContinuous, this.objAngleSnap, this.cGenerationN, this.cgSizeRatio, this.cgSizeRandom, offsetX, offsetY));
                        Engine.addModule(new ModuleCurl(this.parameters, this.generation, this.pType, this.sColor, nextOpacity, this.curveVisible, this.angle, this.x, this.y, this.side,this.spiralSize + (this.spiralSize*this.cgSizeRatio*this.generation)+ (0.5+Engine.rand()*this.cgSizeRandom), this.width, this.pWidth, this.spiral + this.tail, this.sCircle, this.sCircleSize, this.sCircleSizeRatio, this.sCircleSizeRandom, this.scColor, this.tail, this.boxRatio, this.pr , this.flip, this.leaves, this.sLeaves, this.slPoints, 1, this.objAngleSnap, this.cGenerationN, this.cgSizeRatio, this.cgSizeRandom, offsetX, offsetY));
                    }                
                    total-=2;
                    this.child++;
                
                }else{
                    Engine.addModule(new ModuleCurl(this.parameters, this.generation, this.pType, this.sColor, nextOpacity,  this.curveVisible, this.angle, this.x, this.y, Math.floor(Engine.rand()*2),this.spiralSize + (this.spiralSize*this.cgSizeRatio*this.generation)+ (0.5+Engine.rand()*this.cgSizeRandom), this.width, this.pWidth, this.spiral, this.sCircle, this.sCircleSize, this.sCircleSizeRatio, this.sCircleSizeRandom, this.scColor, this.tail, this.boxRatio, this.pr , this.flip, this.leaves, this.sLeaves, this.slPoints, this.cContinuous, this.objAngleSnap, this.cGenerationN, this.cgSizeRatio, this.cgSizeRandom, offsetX, offsetY));
                    total--;
                    this.child++;
                }
            }

 
            
        // leaf

            if( (this.leaves[0] > 0 && this.cContinuous == 0 && this.step == this.spiral-1 && Engine.rand()>0.75) || (Engine.rand() < this.leaves[0] && this.step < 40)){
                if(Engine.rand() > 0.5 || this.leaves[2] == 0){
                    Engine.addModule(new ModuleLeaf (this.parameters, this.angle , this.x, this.y, this.leaves, this.flip, this.pr, this.boxRatio, this.objAngleSnap, this.cColorFade, offsetX, offsetY));
                }else{
                    Engine.addModule(new ModuleLeaf (this.parameters, this.angle - 3.14/2, this.x, this.y, this.leaves, this.flip, this.pr, this.boxRatio, this.objAngleSnap, this.cColorFade, offsetX, offsetY));
                }
            }


            var len = Math.sqrt (Math.pow(this.x1-this.x,2) + Math.pow(this.y1-this.y,2));
            
            var sx = (this.y1-this.y)*this.width/len;
            var sy = (this.x1-this.x)*this.width/len;
            
            if (this.step == 0){
                this.pointsA.push(new Vector3(this.x1-sx,this.y1+sy));
                this.pointsB.push(new Vector3(this.x1+sx,this.y1-sy));
            }
            this.pointsA.push(new Vector3(this.x-sx,this.y+sy));
            this.pointsB.push(new Vector3(this.x+sx,this.y-sy));


            Engine.setModuleParameter (this, "call", "render", 1)
        }
        if (this.sCircle > 0 ){

            if (this.sCircle <= 2)
            {
                    for ( i = 0; i < 2*3.14; i += 0.0628)
                    {
                        switch (this.sCircle)
                        {
                            case 1:
                                    this.pointsC.push(new Vector3(this.x+Math.cos(i)*this.width,this.y+Math.sin(i)*this.width, -0.25));
                                    break;
                            case 2:
                                    this.pointsC.push(new Vector3(this.x + Math.sin(this.angle)*this.spiralSize*sCircleSize  +Math.cos(i)*this.spiralSize*sCircleSize, this.y - Math.cos(this.angle)*this.spiralSize*sCircleSize*this.side  +Math.sin(i)*this.spiralSize*sCircleSize, 0.5));
                                    break;
                        }
                    }
              }else{
                    var ran = Engine.rand();
                    for (var k = 0; k < fnShape[this.sCircle-3]; k++){
                        var fx = fsShape[this.sCircle-3][0][0]/2;
                        var fy = fsShape[this.sCircle-3][0][1]/2;

                        for (var j = 0; j < fsShape[this.sCircle-3][k+1].length-1; j+=2){
                            this.pointsF[k].push(new Vector3((fsShape[this.sCircle-3][k+1][j]/2 -fx)*(this.sCircleSize+this.sCircleSizeRatio+ (ran-0.5)*this.sCircleSizeRandom)+this.x, (fsShape[this.sCircle-3][k+1][j+1]/2 -fy)*(this.sCircleSize+this.sCircleSizeRatio+ (ran-0.5)*this.sCircleSizeRandom)+this.y, 0.5));
                        }
                    }
               }
          }
    }

    this.finish = true;      
    return kCallAgain;
    
}

ModuleCurl.prototype.render = function (api, env)
{
    api.command(kpsStartTask,1/curlTotal);
    curlTotal--
    if (this.finish){
        for (var i = this.pointsB.length-1; i >= 0 ; i--){
            this.pointsA.push(this.pointsB[i]);
        }

    var cr  = this.sColor[0];
    var cg = this.sColor[1];
    var cb = this.sColor[2];

    var scr  = this.scColor[0];
    var scg = this.scColor[1];
    var scb = this.scColor[2];




   if (this.curveVisible){
        api.pushMatrix();
        frame = new Frame3();
        api.setFrame(frame);
        if (api.instanceExists("pointsA"))     // instance
            api.deleteInstance("pointsA");

        if (api.defineInstance("pointsA")) 
        {
            api.lineWidth (0.1);
            api.Polygon( this.pointsA );                 
            api.endInstance();
        }
        api.popMatrix();
   }
   if (this.sCircle > 0 && this.cContinuous == 0){
        if (this.sCircle <= 2){
            api.pushMatrix();
            frame = new Frame3();
            api.setFrame(frame);
            if (api.instanceExists("pointsC"))     // instance
                api.deleteInstance("pointsC"); 
            if (api.defineInstance("pointsC")) 
            {
                api.lineWidth (0.1);
                api.Polygon( this.pointsC );               
                api.endInstance();
            }
            api.popMatrix();

        }else{
            for(var k = 0; k < fnShape[this.sCircle-3]; k++){
                api.pushMatrix();
                frame = new Frame3();
                api.setFrame(frame);
                if (api.instanceExists("points"+k))     // instance
                    api.deleteInstance("points"+k);

                if (api.defineInstance("points"+k)) 
                {
                    api.lineWidth (0.1);
                    api.Polygon(this.pointsF[k]);
                    api.endInstance();
                }
                api.popMatrix();
            }
        }
    } 


    

    api.pushMatrix();
    api.scale(frameScale,frameScale,frameScale);
            
    api.Color (kStrokeColor, cr,cg,cb, this.cColorFade);            // top left
    api.lineWidth (0.1);
    api.Color (kFillColor, cr,cg,cb, this.cColorFade);
    //Engine.message(this.flip, " ", this.pr, " " , this.boxRatio);
    api.translate (this.offsetX,this.offsetY);
    if ( (this.flip && this.pr < this.boxRatio) || (!this.flip && this.pr >(1-this.boxRatio))){
       if (this.curveVisible){
            api.lineWidth (0.01);
            api.Color (kStrokeColor, cr,cg,cb, this.cColorFade);
            api.Color (kFillColor, cr,cg,cb, this.cColorFade);
            api.drawInstance("pointsA");   
       }
       if (this.sCircle > 0 && this.cContinuous == 0){
            api.Color (kStrokeColor, scr,scg,scb, this.cColorFade);
            api.Color (kFillColor, scr,scg,scb, this.cColorFade);
            if (this.sCircle <= 2){
            api.drawInstance("pointsC");  
            }else{
                for(var k = 0; k < fnShape[this.sCircle-3]; k++){
                    api.drawInstance("points"+k);
                }
            }
        } 
    }
    api.translate (-this.offsetX,-this.offsetY);




    api.Color (kStrokeColor, cr,cg,cb,this.cColorFade);
    api.Color (kFillColor, cr,cg,cb,this.cColorFade);
    api.scale(-1,1);                                  //top right
    api.translate (outputSizeX,0);
    api.translate (this.offsetX,this.offsetY);
    if ( (this.flip && this.pr < this.boxRatio) || (!this.flip && this.pr >(1-this.boxRatio))){
       if (this.curveVisible){
            api.lineWidth (0.01);
            api.Color (kStrokeColor, cr,cg,cb,this.cColorFade);
            api.Color (kFillColor, cr,cg,cb,this.cColorFade);
            api.drawInstance("pointsA");  
       }
       if (this.sCircle > 0 && this.cContinuous == 0){
            api.Color (kStrokeColor, scr,scg,scb,this.cColorFade);
            api.Color (kFillColor, scr,scg,scb,this.cColorFade);
            if (this.sCircle <= 2){
            api.drawInstance("pointsC");  
            }else{
                for(var k = 0; k < fnShape[this.sCircle-3]; k++){
                    api.drawInstance("points"+k);
                }
            }
        } 
    }
    api.translate (-this.offsetX,-this.offsetY);

    api.Color (kStrokeColor, cr,cg,cb,this.cColorFade);
    api.Color (kFillColor, cr,cg,cb,this.cColorFade);
    
    api.translate (-outputSizeX,0);
    api.scale(-1,1)
    
    api.scale(1,-1);                                  //bottom left
    api.translate (0, outputSizeY);
    api.translate (this.offsetX,this.offsetY);
    if ( (this.flip && this.pr < this.boxRatio) || (!this.flip && this.pr >(1-this.boxRatio))){
       if (this.curveVisible){
            api.lineWidth (0.01);
            api.Color (kStrokeColor, cr,cg,cb,this.cColorFade);
            api.Color (kFillColor, cr,cg,cb,this.cColorFade);
            api.drawInstance("pointsA");
       }
       if (this.sCircle > 0 && this.cContinuous == 0){
            api.Color (kStrokeColor, scr,scg,scb,this.cColorFade);
            api.Color (kFillColor, scr,scg,scb,this.cColorFade);
            if (this.sCircle <= 2){
            api.drawInstance("pointsC");  
            }else{
                for(var k = 0; k < fnShape[this.sCircle-3]; k++){
                    api.drawInstance("points"+k);
                }
            }
        } 
    }
    api.translate (-this.offsetX,-this.offsetY);

    api.Color (kStrokeColor, cr,cg,cb,this.cColorFade);
    api.Color (kFillColor, cr,cg,cb,this.cColorFade);
    api.scale(-1,1);                                  //bottom right
    api.translate (+outputSizeX,0);
    api.translate (this.offsetX,this.offsetY);
    if ( (this.flip && this.pr < this.boxRatio) || (!this.flip && this.pr >(1-this.boxRatio))){
       if (this.curveVisible){
            api.lineWidth (0.01);
            api.Color (kStrokeColor, cr,cg,cb,this.cColorFade);
            api.Color (kFillColor, cr,cg,cb,this.cColorFade);
            api.drawInstance("pointsA");
       }
       if (this.sCircle > 0 && this.cContinuous == 0){
            api.Color (kStrokeColor, scr,scg,scb,this.cColorFade);
            api.Color (kFillColor, scr,scg,scb,this.cColorFade);
            if (this.sCircle <= 2){
            api.drawInstance("pointsC");  
            }else{
                for(var k = 0; k < fnShape[this.sCircle-3]; k++){
                    api.drawInstance("points"+k);
                }
            }
        }
    }
    api.translate (-this.offsetX,-this.offsetY);

    api.Color (kStrokeColor, cr,cg,cb,this.cColorFade);
    api.Color (kFillColor, cr,cg,cb,this.cColorFade);
    api.translate (-outputSizeX,0);
    api.scale(-1,1)
    api.translate (0, -outputSizeY);

    api.rotate(-90);                                  //left top
    api.translate (this.offsetX,this.offsetY);
    if ( (this.flip && this.pr < 1/this.boxRatio) || (!this.flip && this.pr > (1-1/this.boxRatio))){
       if (this.curveVisible){
            api.lineWidth (0.01);
            api.Color (kStrokeColor, cr,cg,cb,this.cColorFade);
            api.Color (kFillColor, cr,cg,cb,this.cColorFade);
            api.drawInstance("pointsA");
       }
       if (this.sCircle > 0 && this.cContinuous == 0){
            api.Color (kStrokeColor, scr,scg,scb,this.cColorFade);
            api.Color (kFillColor, scr,scg,scb,this.cColorFade);
            if (this.sCircle <= 2){
            api.drawInstance("pointsC");  
            }else{
                for(var k = 0; k < fnShape[this.sCircle-3]; k++){
                    api.drawInstance("points"+k);
                }
            }
        } 
    }
    api.translate (-this.offsetX,-this.offsetY);
    
    api.Color (kStrokeColor, cr,cg,cb,this.cColorFade);
    api.Color (kFillColor, cr,cg,cb,this.cColorFade);
    api.scale(1,-1);                                  //right top
    api.translate (outputSizeX,0);
    api.translate (this.offsetX,this.offsetY);
    if ( (this.flip && this.pr < 1/this.boxRatio) || (!this.flip && this.pr > (1-1/this.boxRatio))){
       if (this.curveVisible){
            api.lineWidth (0.01);
            api.Color (kStrokeColor, cr,cg,cb,this.cColorFade);
            api.Color (kFillColor, cr,cg,cb,this.cColorFade);
            api.drawInstance("pointsA");
       }
       if (this.sCircle > 0 && this.cContinuous == 0){
            api.Color (kStrokeColor, scr,scg,scb,this.cColorFade);
            api.Color (kFillColor, scr,scg,scb,this.cColorFade);
            if (this.sCircle <= 2){
            api.drawInstance("pointsC");  
            }else{
                for(var k = 0; k < fnShape[this.sCircle-3]; k++){
                    api.drawInstance("points"+k);
                }
            }
        } 
    }
    api.translate (-this.offsetX,-this.offsetY);

    api.Color (kStrokeColor, cr,cg,cb,this.cColorFade);
    api.Color (kFillColor, cr,cg,cb,this.cColorFade);
    api.translate (-outputSizeX,0);
    api.scale(1,-1);
                 
    api.scale(-1,1);                                  // left bottom
    api.translate (0,outputSizeY);
    api.translate (this.offsetX,this.offsetY);
    if ( (this.flip && this.pr < 1/this.boxRatio) || (!this.flip && this.pr > (1-1/this.boxRatio))){
       if (this.curveVisible){
            api.lineWidth (0.01);
            api.Color (kStrokeColor, cr,cg,cb,this.cColorFade);
            api.Color (kFillColor, cr,cg,cb,this.cColorFade);
            api.drawInstance("pointsA");
       }
       if (this.sCircle > 0 && this.cContinuous == 0){
            api.Color (kStrokeColor, scr,scg,scb,this.cColorFade);
            api.Color (kFillColor, scr,scg,scb,this.cColorFade);
            if (this.sCircle <= 2){
            api.drawInstance("pointsC");  
            }else{
                for(var k = 0; k < fnShape[this.sCircle-3]; k++){
                    api.drawInstance("points"+k);
                }
            }
        } 
    }
    api.translate (-this.offsetX,-this.offsetY);
    
    api.Color (kStrokeColor, cr,cg,cb,this.cColorFade);
    api.Color (kFillColor, cr,cg,cb,this.cColorFade);
    api.scale(1,-1);                                  //right top
    api.translate (outputSizeX,0);
    api.translate (this.offsetX,this.offsetY);
    if ( (this.flip && this.pr < 1/this.boxRatio) || (!this.flip && this.pr > (1-1/this.boxRatio))){
       if (this.curveVisible){
            api.lineWidth (0.01);
            api.Color (kStrokeColor, cr,cg,cb,this.cColorFade);
            api.Color (kFillColor, cr,cg,cb,this.cColorFade);
            api.drawInstance("pointsA");
       }
       if (this.sCircle > 0 && this.cContinuous == 0){
            api.Color (kStrokeColor, scr,scg,scb,this.cColorFade);
            api.Color (kFillColor, scr,scg,scb,this.cColorFade);
            if (this.sCircle <= 2){
            api.drawInstance("pointsC");  
            }else{
                for(var k = 0; k < fnShape[this.sCircle-3]; k++){
                    api.drawInstance("points"+k);
                }
            }
        } 
    }
    api.translate (-this.offsetX,-this.offsetY);
    api.translate (-outputSizeX,0);
    api.scale(1,-1)



    api.popMatrix()

    
    }

    api.command(kpsFinishTask);
}


function ModuleLeaf(parameters, angle, x, y, leaves, flip, pr, boxRatio, objAngleSnap, cColorFade, offsetX, offsetY)
{
    this.offsetX = offsetX;
    this.offsetY = offsetY;
    
    this.parameters = parameters;
    this.angle = angle;
    this.x = x;
    this.y =y;
    this.leaves = leaves;
    this.flip = flip;
    this.pr = pr;
    this.boxRatio = boxRatio;
    this.objAngleSnap = objAngleSnap;
    
    this.lPoints = new Array();

    var rand = 1+(Engine.rand()-0.5)*leaves[10];
    this.lr  = leaves[7] *rand;
    this.lg = leaves[8] *rand;
    this.lb = leaves[9] *rand;
    
    if (this.lr>1)
        this.lr = 1;
    if (this.lg>1)
        this.lg = 1;
    if (this.lb>1)
        this.lb = 1;
    
    this.cColorFade = cColorFade;
    

}

ModuleLeaf.prototype.produce = function (system)
{
    return kDontCallAgain;
}

ModuleLeaf.prototype.render = function (api, env)
{

    if(this.objAngleSnap)
        this.angle = 3.14/4;
    var leavesSize = this.leaves[3];
    var pattern = this.leaves[1];
    var width = this.leaves[4];
    var reverse = this.leaves[5];
    var leavesRandom = this.leaves[6];
    
    if(!reverse){
        var x0 = shape[pattern][0];
        var y0 = shape[pattern][1];
    } else {
        var x0 = shape[pattern][shape[pattern].length-2];
        var y0 = shape[pattern][shape[pattern].length-1];
        this.angle -= 3.14;
    }

    this.angle += 3.14*3/4;
    
    var size = ((Engine.rand()-0.5)*leavesRandom*leavesSize)+leavesSize;
    
    
    for (i = 0; i < shape[pattern].length-2; i += 2){

        var x1= (shape[pattern][i] - x0)*size * width;
        var y1 = (shape[pattern][i+1] - y0)*size;
        var x2 = x1*Math.cos(this.angle) - y1*Math.sin(this.angle);
        var y2 = x1*Math.sin(this.angle) + y1*Math.cos(this.angle);
        
        this.lPoints.push(new Vector3(this.x + x2, this.y+ y2, 0.25));
    }   

    for (i = shape[pattern].length - 2; i > 0; i -= 2){

        var x1= -(shape[pattern][i] - x0)*size *width;
        var y1 = (shape[pattern][i+1] - y0)*size;
        var x2 = x1*Math.cos(this.angle) - y1*Math.sin(this.angle);
        var y2 = x1*Math.sin(this.angle) + y1*Math.cos(this.angle);
        
        this.lPoints.push(new Vector3(this.x + x2, this.y+ y2, 0.25));
    }


    api.pushMatrix();
    frame = new Frame3();
    api.setFrame(frame);
    if (api.instanceExists("leaf"))     // instance
        api.deleteInstance("leaf");

    if (api.defineInstance("leaf")) 
    {
        api.lineWidth (0.1);
        api.Polygon( this.lPoints );                 
        api.endInstance();
    }
    api.popMatrix();

    
    this.angle = 0;

    api.pushMatrix();
    api.scale(frameScale,frameScale,frameScale);
    
    if(!this.objAngleSnap)
        api.rotate(this.angle);


    
    api.Color (kStrokeColor, this.lr,this.lg,this.lb, this.cColorFade);            // top left
    api.lineWidth (0.1);
    api.Color (kFillColor, this.lr,this.lg,this.lb, this.cColorFade);
    api.translate (this.offsetX, this.offsetY);
    if ( (this.flip && this.pr < this.boxRatio) || (!this.flip && this.pr >(1-this.boxRatio)))
        api.drawInstance("leaf");   
    api.translate (-this.offsetX, -this.offsetY);
    

    api.scale(-1,1);                                  //top right
    api.translate (outputSizeX,0);
    api.translate (this.offsetX, this.offsetY);
    if ( (this.flip && this.pr < this.boxRatio) || (!this.flip && this.pr >(1-this.boxRatio)))
        api.drawInstance("leaf");   
    api.translate (-this.offsetX, -this.offsetY);
    api.translate (-outputSizeX,0);
    api.scale(-1,1)
    
    api.scale(1,-1);                                  //bottom left
    api.translate (0, outputSizeY);
    api.translate (this.offsetX, this.offsetY);
    if ( (this.flip && this.pr < this.boxRatio) || (!this.flip && this.pr >(1-this.boxRatio)))
        api.drawInstance("leaf");   
    api.translate (-this.offsetX, -this.offsetY);

    api.scale(-1,1);                                  //bottom right
    api.translate (+outputSizeX,0);
    api.translate (this.offsetX, this.offsetY);
    if ( (this.flip && this.pr < this.boxRatio) || (!this.flip && this.pr >(1-this.boxRatio)))
        api.drawInstance("leaf");   
    api.translate (-this.offsetX, -this.offsetY);
    api.translate (-outputSizeX,0);
    api.scale(-1,1)
    api.translate (0, -outputSizeY);

    api.rotate(-90);                                  //left top
    api.translate (this.offsetX, this.offsetY);
    if ( (this.flip && this.pr < 1/this.boxRatio) || (!this.flip && this.pr > (1-1/this.boxRatio)))
        api.drawInstance("leaf");   
    api.translate (-this.offsetX, -this.offsetY);
    
    api.scale(1,-1);                                  //right top
    api.translate (outputSizeX,0);
    api.translate (this.offsetX, this.offsetY);
    if ( (this.flip && this.pr < 1/this.boxRatio) || (!this.flip && this.pr > (1-1/this.boxRatio)))
        api.drawInstance("leaf");   
    api.translate (-this.offsetX, -this.offsetY);
    api.translate (-outputSizeX,0);
    api.scale(1,-1);
                 
    api.scale(-1,1);                                  // left bottom
    api.translate (0,outputSizeY);
    api.translate (this.offsetX, this.offsetY);
    if ( (this.flip && this.pr < 1/this.boxRatio) || (!this.flip && this.pr > (1-1/this.boxRatio)))
        api.drawInstance("leaf");   
    api.translate (-this.offsetX, -this.offsetY);
    
    api.scale(1,-1);                                  //right top
    api.translate (outputSizeX,0);
    api.translate (this.offsetX, this.offsetY);
    if ( (this.flip && this.pr < 1/this.boxRatio) || (!this.flip && this.pr > (1-1/this.boxRatio)))
        api.drawInstance("leaf");   
    api.translate (-this.offsetX, -this.offsetY);
    api.translate (-outputSizeX,0);
    api.scale(1,-1);



    api.popMatrix()
}





function ModuleLine (api,x,y, x1,y1, size, cr,cg,cb, depth)
{

   var lenX = Math.abs(x1-x);
   var lenY = Math.abs(y1-y);

   var exX = 0;
   var exY =0;

   if (lenX == 0){
       exX = 0;
       exY = 1;
   }else if (lenY == 0){
       exX = 1;
       exY = 0;
   }else if (lenX > lenY){
       exX = 1;
       exY = lenY/lenX;
   }else{
       exY = 1;
       exX = lenX/lenY;
   }
   
    var exX0 = 0;
    var exY0 = 0;
    var exX1 = 0;
    var exY1 = 0;
    
    if (x1 > x){
        exX0 = -exX;
        exX1 = exX;
    }else{
        exX0 = exX;
        exX1 = -exX;
   }

    if (y1 > y){
        exY0 = -exY;
        exY1 = exY;
    }else{
        exY0 = exY;
        exY1 = -exY;
    }

    this.x0 = x + exX0;
    this.y0 = y + exY0;
    this.x1 = x1 + exX1;
    this.y1 = y1 + exY1;
    this.w = size;
    this.cr = cr;
    this.cg = cg;
    this.cb = cb;
    
    this.depth = depth;
    
}

ModuleLine.prototype.produce = function (system)
{
        return kDontCallAgain;
    
}

ModuleLine.prototype.render = function (api, env)
{


    var len = Math.sqrt (Math.pow(this.x1-this.x0,2) + Math.pow(this.y1-this.y0,2));
    
    var sx = (this.y1-this.y0)*this.w/len;
    var sy = (this.x1-this.x0)*this.w/len;

    var t = new Array;
    t = [ new Vector3(this.x0-sx,this.y0+sy, this.depth), 
                                    new Vector3(this.x0+sx,this.y0-sy, this.depth),
                                    new Vector3(this.x1+sx,this.y1-sy, this.depth),
                                    new Vector3(this.x1-sx,this.y1+sy, this.depth)
                                    ];                

    api.Color (kStrokeColor, this.cr,this.cg,this.cb,1)
    api.lineWidth (0.0001)
    api.Color (kFillColor, this.cr,this.cg,this.cb,1)
    api.Polygon( t )    

}


function tLine(api,x0,y0,x1,y1, w, cr,cg,cb)
{

    var len = Math.sqrt (Math.abs(Math.pow(x1-x0,2) + Math.pow(y1-y0,2)));
    
    var sx = (y1-y0)*w/len;
    var sy = (x1-x0)*w/len;

    var t = new Array;
    t = [ new Vector3(x0-sx,y0+sy), 
                                    new Vector3(x0+sx,y0-sy),
                                    new Vector3(x1+sx,y1-sy),
                                    new Vector3(x1-sx,y1+sy)
                                    ];                

    api.Color (kStrokeColor, cr,cg,cb,1)
    api.lineWidth (0.01)
    api.Color (kFillColor, cr,cg,cb,1)
    api.Polygon( t )    


}

function tBox(api, boxType, gap, x0,y0,x1,y1, w, r, cr,cg,cb, offsetX, offsetY, cornerSize)
{
    x0 += offsetX;
    x1 += offsetX;
    y0 += offsetY;
    y1 += offsetY;
    
    ex0 = x0+w;    // edge of the x and y  ;  this is done, so when margin is 0, it renders full size
    ey0 = y0+w;
    ex1 = x1-w;
    ey1 = y1-w;
    
    x0 += 1;    // 1 dot error correction
    x1 -= 1;
    y0 += 1;
    y1 -= 1;
    
    switch(boxType)
    {
            case 0:      // simple box
                Engine.addModule(new ModuleLine(api, x0,ey0,   x1,ey0,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex0,y0,   ex0,y1,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex1,y0,   ex1,y1,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, x0,ey1,   x1,ey1,w,cr,cg,cb,0 ));
                break;
                
            case 1:     // double box
                Engine.addModule(new ModuleLine(api, x0,ey0,   x1,ey0,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex0,y0,   ex0,y1,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex1,y0,   ex1,y1,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, x0,ey1,   x1,ey1,w,cr,cg,cb,0 ));
                
                w /= 2;
                Engine.addModule(new ModuleLine(api, x0,ey0+gap,   x1,ey0+gap,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex0+gap,y0,   ex0+gap,y1,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex1-gap,y0,   ex1-gap,y1,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, x0,ey1-gap,   x1,ey1-gap,w,cr,cg,cb,0 ));
                break;
            
            case 2:      // round box
                Engine.addModule(new ModuleLine(api, ex0+r,ey0,   ex1-r,ey0,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex0,ey0+r,   ex0,ey1-r,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex1,ey0+r,   ex1,ey1-r,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex0+r,ey1,   ex1-r,ey1,w,cr,cg,cb,0 ));
                
                var cx0 = 0;
                var cy0 = 0;
                var cx1 = 0;
                var cy1 = 0;

                for (var c = 0.1; c <= 3.3/2; c+= 0.1){
                    
                    cx0 = Math.cos(c)*r;
                    cy0 = Math.sin(c)*r;
                    cx1 = Math.cos(c-0.11)*r;
                    cy1 = Math.sin(c-0.11)*r;
                    
                    Engine.addModule(new ModuleLine(api, ex0+r - cx0,   ey0+r - cy0,   ex0+r - cx1,  ey0+r  -cy1,w,cr,cg,cb,0 ));
                    Engine.addModule(new ModuleLine(api, ex1-r + cx0,   ey0+r - cy0,   ex1-r + cx1,  ey0+r  -cy1,w,cr,cg,cb,0 ));
                    Engine.addModule(new ModuleLine(api, ex1-r + cx0,   ey1-r + cy0,   ex1-r + cx1,  ey1-r  +cy1,w,cr,cg,cb,0 ));
                    Engine.addModule(new ModuleLine(api, ex0+r - cx0,  ey1-r + cy0,   ex0+r - cx1,  ey1-r  +cy1,w,cr,cg,cb,0 ));
                }              
                break; 
                
            case 3:      // round box 2
                Engine.addModule(new ModuleLine(api, ex0+r-w+1,ey0,   ex1-r+w-1,ey0,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex0,ey0+r-w+1,   ex0,ey1-r+w-1,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex1,ey0+r-w+1,   ex1,ey1-r+w-1,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex0+r-w+1,ey1,   ex1-r+w-1,ey1,w,cr,cg,cb,0 ));
                
                var cx0 = 0;
                var cy0 = 0;
                var cx1 = 0;
                var cy1 = 0;

                for (var c = 0.12; c <= 3.14/2; c+= 0.1){
                    
                    cx0 = Math.cos(c)*r;
                    cy0 = Math.sin(c)*r;
                    cx1 = Math.cos(c-0.12)*r;
                    cy1 = Math.sin(c-0.12)*r;
                    
                    Engine.addModule(new ModuleLine(api, ex1 - cx0,   ey1 - cy0,   ex1 - cx1,  ey1  -cy1,w,cr,cg,cb,0 ));
                    Engine.addModule(new ModuleLine(api, ex0 + cx0,   ey1 - cy0,   ex0 + cx1,  ey1  -cy1,w,cr,cg,cb,0 ));
                    Engine.addModule(new ModuleLine(api, ex0 + cx0,   ey0 + cy0,   ex0 + cx1,  ey0  +cy1,w,cr,cg,cb,0 ));
                    Engine.addModule(new ModuleLine(api, ex1 - cx0,  ey0 + cy0,   ex1 - cx1,  ey0  +cy1,w,cr,cg,cb,0 ));
                }     
                c = 3.14/2;
                cx0 = Math.cos(c)*r;
                cy0 = Math.sin(c)*r;
                cx1 = Math.cos(c-0.12)*r;
                cy1 = Math.sin(c-0.12)*r;
                
                Engine.addModule(new ModuleLine(api, ex1 - cx0,   ey1 - cy0,   ex1 - cx1,  ey1  -cy1,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex0 + cx0,   ey1 - cy0,   ex0 + cx1,  ey1  -cy1,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex0 + cx0,   ey0 + cy0,   ex0 + cx1,  ey0  +cy1,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex1 - cx0,  ey0 + cy0,   ex1 - cx1,  ey0  +cy1,w,cr,cg,cb,0 ));
            
                break; 
                
                
            case 4:      // round box 2
            
                var r1 = r/2;
                var smallEdge = cornerSize;
                var edge = r1 *1.5;//+ smallEdge;
            
                Engine.addModule(new ModuleLine(api, ex0+r1-w+1 +edge,ey0,   ex1-r1+w-1 -edge,ey0,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex0,ey0+r1-w+1 +edge,   ex0,ey1-r1+w-1 -edge,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex1,ey0+r1-w+1 +edge,   ex1,ey1-r1+w-1 -edge,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex0+r1-w+1 +edge,ey1,   ex1-r1+w-1 -edge,ey1,w,cr,cg,cb,0 ));

                Engine.addModule(new ModuleLine(api, ex0+r1-w+1 ,ey0 + edge,   ex0+edge+w-1 ,ey0+edge,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex1-edge -w+1,ey0 + edge,   ex1-r1+w-1 ,ey0+edge,w,cr,cg,cb,0 ));

                Engine.addModule(new ModuleLine(api, ex0+edge,ey0+r1-w+1 ,   ex0+edge, ey0+edge +w-1 ,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex0+edge,ey1-edge -w+1,   ex0+edge,ey1-r1+w-1 ,w,cr,cg,cb,0 ));

                Engine.addModule(new ModuleLine(api, ex1-edge,ey0+r1-w+1 ,   ex1-edge,ey0+edge +w-1,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex1-edge,ey1-edge -w+1,   ex1-edge,ey1-r1+w-1 ,w,cr,cg,cb,0 ));
 
 
                Engine.addModule(new ModuleLine(api, ex0+r1-w+1 ,ey1-edge,   ex0+edge +w-1,ey1-edge,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex1-edge-w+1 ,ey1-edge,   ex1-r1+w-1 ,ey1-edge,w,cr,cg,cb,0 ));              
                
                
                var cx0 = 0;
                var cy0 = 0;
                var cx1 = 0;
                var cy1 = 0;



                for (var c = 0.12; c <= 3.14/2; c+= 0.1){
                    
                    cx0 = Math.cos(c)*r1;
                    cy0 = Math.sin(c)*r1;
                    cx1 = Math.cos(c-0.12)*r1;
                    cy1 = Math.sin(c-0.12)*r1;
                    
                    Engine.addModule(new ModuleLine(api, ex1 - cx0 -edge,   ey1 - cy0,   ex1 - cx1 -edge,  ey1  -cy1,w,cr,cg,cb,0 ));
                    Engine.addModule(new ModuleLine(api, ex0 + cx0 +edge,   ey1 - cy0,   ex0 + cx1 +edge,  ey1  -cy1,w,cr,cg,cb,0 ));
                    Engine.addModule(new ModuleLine(api, ex0 + cx0 +edge,   ey0 + cy0,   ex0 + cx1 +edge,  ey0  +cy1,w,cr,cg,cb,0 ));
                    Engine.addModule(new ModuleLine(api, ex1 - cx0 -edge,  ey0 + cy0,   ex1 - cx1 -edge,  ey0  +cy1,w,cr,cg,cb,0 ));
                    
                    Engine.addModule(new ModuleLine(api, ex1 - cx0 ,   ey1 - cy0-edge,   ex1 - cx1,  ey1  -cy1 -edge,w,cr,cg,cb,0 ));
                    Engine.addModule(new ModuleLine(api, ex0 + cx0 ,   ey1 - cy0-edge,   ex0 + cx1,  ey1  -cy1 -edge,w,cr,cg,cb,0 ));
                    Engine.addModule(new ModuleLine(api, ex0 + cx0 ,   ey0 + cy0+edge,   ex0 + cx1,  ey0  +cy1 +edge,w,cr,cg,cb,0 ));
                    Engine.addModule(new ModuleLine(api, ex1 - cx0 ,  ey0 + cy0+edge,   ex1 - cx1,  ey0  +cy1 +edge,w,cr,cg,cb,0 ));
                }     
                c = 3.14/2;
                cx0 = Math.cos(c)*r1;
                cy0 = Math.sin(c)*r1;
                cx1 = Math.cos(c-0.12)*r1;
                cy1 = Math.sin(c-0.12)*r1;
                
                Engine.addModule(new ModuleLine(api, ex1 - cx0 -edge,   ey1 - cy0,   ex1 - cx1 -edge,  ey1  -cy1,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex0 + cx0 +edge,   ey1 - cy0,   ex0 + cx1 +edge,  ey1  -cy1,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex0 + cx0  +edge,   ey0 + cy0,   ex0 + cx1 +edge,  ey0  +cy1,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex1 - cx0 -edge,  ey0 + cy0,   ex1 - cx1 -edge,  ey0  +cy1,w,cr,cg,cb,0 ));
                
                Engine.addModule(new ModuleLine(api, ex1 - cx0 ,   ey1 - cy0-edge,   ex1 - cx1,  ey1  -cy1 -edge,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex0 + cx0 ,   ey1 - cy0-edge,   ex0 + cx1,  ey1  -cy1 -edge,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex0 + cx0 ,   ey0 + cy0+edge,   ex0 + cx1,  ey0  +cy1 +edge,w,cr,cg,cb,0 ));
                Engine.addModule(new ModuleLine(api, ex1 - cx0 ,  ey0 + cy0+edge,   ex1 - cx1,  ey0  +cy1 +edge,w,cr,cg,cb,0 ));
            
                break; 
                
    }

}


function artBox(api, boxType, flip, ax0, ay0, ax1, ay1, x0,y0,x1,y1, w, r, r1, cr,cg,cb, offsetX, offsetY, cornerSize, spec)  // spec = -1 ~ +1   angle of surface  , ax0,ay0,ax1,ay1 .. these are the locations for center of the arch when the arch is reverced
{


    
    x0 += offsetX;
    x1 += offsetX;
    y0 += offsetY;
    y1 += offsetY;
    
    ex0 = x0+w;    // edge of the x and y  ;  this is done, so when margin is 0, it renders full size
    ey0 = y0+w;
    ex1 = x1-w;
    ey1 = y1-w;
    
    x0 += 1;    // 1 dot error correction
    x1 -= 1;
    y0 += 1;
    y1 -= 1;
    
    
    
    
    ax0 += offsetX;
    ax1 += offsetX;
    ay0 += offsetY;
    ay1 += offsetY;
    
    aex0 = ax0+w;    // edge of the x and y  ;  this is done, so when margin is 0, it renders full size
    aey0 = ay0+w;
    aex1 = ax1-w;
    aey1 = ay1-w;
    
    

    
    cr1= shade(cr, spec);
    if(flip)
        cr2= cr1;
    else
        cr2= shade(cr, -spec);
    
    cg1= shade(cg, spec);
    if(flip)
        cg2 = cg1;
    else
        cg2= shade(cg, -spec);
    
    cb1= shade(cb, spec);
    if(flip)
        cb2=cb1;
    else
        cb2= shade(cb, -spec);
    
    switch(boxType)
    {
            case 0:      // simple box
                Engine.addModule(new ModuleLine(api, x0,ey0,   x1,ey0,w,cr1,cg1,cb1,0 ));
                Engine.addModule(new ModuleLine(api, ex0,y0,   ex0,y1,w,cr1,cg1,cb1,0 ));
                Engine.addModule(new ModuleLine(api, ex1,y0,   ex1,y1,w,cr2,cg2,cb2,0 ));
                Engine.addModule(new ModuleLine(api, x0,ey1,   x1,ey1,w,cr2,cg2,cb2,0 ));
                break;
                
            case 1:     // dummy
                Engine.addModule(new ModuleLine(api, x0,ey0,   x1,ey0,w,cr1,cg1,cb1,0 ));
                Engine.addModule(new ModuleLine(api, ex0,y0,   ex0,y1,w,cr1,cg1,cb1,0 ));
                Engine.addModule(new ModuleLine(api, ex1,y0,   ex1,y1,w,cr2,cg2,cb2,0 ));
                Engine.addModule(new ModuleLine(api, x0,ey1,   x1,ey1,w,cr2,cg2,cb2,0 ));
                break;
            
            case 2:      // round box
                Engine.addModule(new ModuleLine(api, ex0+r,ey0,   ex1-r,ey0,w,cr1,cg1,cb1,0 ));
                Engine.addModule(new ModuleLine(api, ex0,ey0+r,   ex0,ey1-r,w,cr1,cg1,cb1,0 ));
                Engine.addModule(new ModuleLine(api, ex1,ey0+r,   ex1,ey1-r,w,cr2,cg2,cb2,0 ));
                Engine.addModule(new ModuleLine(api, ex0+r,ey1,   ex1-r,ey1,w,cr2,cg2,cb2,0 ));
                
                var cx0 = 0;
                var cy0 = 0;
                var cx1 = 0;
                var cy1 = 0;
                
                var step = (Math.PI/2)/120;

                for (var c = step; c <= Math.PI/2; c+= step){
                    
                    cx0 = Math.cos(c)*r;
                    cy0 = Math.sin(c)*r;
                    cx1 = Math.cos(c-step)*r;
                    cy1 = Math.sin(c-step)*r;
                    
                    crA= valueChange(cr1, cr2, c/(Math.PI/2));
                    crB= valueChange(cr2, cr1, c/(Math.PI/2));
                    
                    cgA= valueChange(cg1, cg2, c/(Math.PI/2));
                    cgB= valueChange(cg2, cg1, c/(Math.PI/2));
                    
                    cbA= valueChange(cb1, cb2, c/(Math.PI/2));
                    cbB= valueChange(cb2, cb1, c/(Math.PI/2));
                                  
                    
                    Engine.addModule(new ModuleLine(api, ex0+r - cx0,   ey0+r - cy0,   ex0+r - cx1,  ey0+r  -cy1,w,cr1,cg1,cb1,0 ));
                    Engine.addModule(new ModuleLine(api, ex1-r + cx0,   ey0+r - cy0,   ex1-r + cx1,  ey0+r  -cy1,w,crB,cgB,cbB,0 ));
                    Engine.addModule(new ModuleLine(api, ex1-r + cx0,   ey1-r + cy0,   ex1-r + cx1,  ey1-r  +cy1,w,cr2,cg2,cb2,0 ));
                    Engine.addModule(new ModuleLine(api, ex0+r - cx0,   ey1-r + cy0,   ex0+r - cx1,  ey1-r  +cy1,w,crA,cgA,cbA,0 ));
                }              
                break; 
                
            case 3:      // round box 2
               r1a = r1-(r-r1)/2.35;
     
                r2  = r1+Math.abs(ax0-x0);   
                
                var a = Math.abs(ax0-x0);
                if (r2 == 0)
                    var dAngle = 0;
                else
                    var dAngle = Math.asin(a/r2);

                var step = (Math.PI/2-dAngle)/120;
                var atemp = Math.PI/2-dAngle -step-dAngle;

                if (dAngle < 0)
                    dAngle = 0;
                else if (dAngle >= (Math.PI/2-step)/2)
                {
                    Engine.addModule(new ModuleLine(api, x0,ey0,   x1,ey0,w,cr1,cg1,cb1,0 ));
                    Engine.addModule(new ModuleLine(api, ex0,y0,   ex0,y1,w,cr1,cg1,cb1,0 ));
                    Engine.addModule(new ModuleLine(api, ex1,y0,   ex1,y1,w,cr2,cg2,cb2,0 ));
                    Engine.addModule(new ModuleLine(api, x0,ey1,   x1,ey1,w,cr2,cg2,cb2,0 ));
                    break;    
                }
            
            
                Engine.addModule(new ModuleLine(api, ex0+r1a-w+1.5,ey0,   ex1-r1a+w-1.5,ey0,w,cr1,cg1,cb1,-0.3 ));
                Engine.addModule(new ModuleLine(api, ex0,ey0+r1a-w+1.5,   ex0,ey1-r1a+w-1.5,w,cr1,cg1,cb1,-0.3 ));
                Engine.addModule(new ModuleLine(api, ex1,ey0+r1a-w+1.5,   ex1,ey1-r1a+w-1.5,w,cr2,cg2,cb2,-0.3 ));
                Engine.addModule(new ModuleLine(api, ex0+r1a-w+1.5,ey1,   ex1-r1a+w-1.5,ey1,w,cr2,cg2,cb2,-0.3 ));
                       
//Engine.message(w, "  ", step)                     

                var cx0 = 0;
                var cy0 = 0;
                var cx1 = 0;
                var cy1 = 0;
                
                var w1 = ((Math.PI/2-step)/2 - dAngle)*1.25;
                if (w1 <= 0.55)
                    w1 = 0.55;

                for (var c = step+dAngle; c <= Math.PI/2-dAngle; c+= step){
                    
                    
                    cx0 = Math.cos(c)*r2;
                    cy0 = Math.sin(c)*r2;
                    cx1 = Math.cos(c-step)*r2;
                    cy1 = Math.sin(c-step)*r2;
                    
                    crA= valueChange(cr1, cr2, (c-step-dAngle)/atemp);
                    crB= valueChange(cr2, cr1, (c-step-dAngle)/atemp);
                    
                    cgA= valueChange(cg1, cg2, (c-step-dAngle)/atemp);
                    cgB= valueChange(cg2, cg1, (c-step-dAngle)/atemp);
                    
                    cbA= valueChange(cb1, cb2, (c-step-dAngle)/atemp);
                    cbB= valueChange(cb2, cb1, (c-step-dAngle)/atemp);
                    
                    Engine.addModule(new ModuleLine(api, aex1 - cx0,    aey1 - cy0,   aex1 - cx1,  aey1  -cy1,w1,cr2,cg2,cb2,-0.1 ));
                    Engine.addModule(new ModuleLine(api, aex0 + cx0,   aey1 - cy0,   aex0 + cx1,  aey1  -cy1,w1,crB,cgB,cbB,-0.1 ));
                    Engine.addModule(new ModuleLine(api, aex0 + cx0,   aey0 + cy0,   aex0 + cx1,  aey0  +cy1,w1,cr1,cg1,cb1,-0.1 ));
                    Engine.addModule(new ModuleLine(api, aex1 - cx0,    aey0 + cy0,   aex1 - cx1,  aey0  +cy1,w1,crA,cgA,cbA,-0.1 ));
                }     
                c = Math.PI/2-dAngle;
                cx0 = Math.cos(c)*r2;
                cy0 = Math.sin(c)*r2;
                cx1 = Math.cos(c-step/2)*r2;
                cy1 = Math.sin(c-step/2)*r2;

                crA= valueChange(cr1, cr2, (c-step-dAngle)/atemp);
                crB= valueChange(cr2, cr1, (c-step-dAngle)/atemp);
                
                cgA= valueChange(cg1, cg2, (c-step-dAngle)/atemp);
                cgB= valueChange(cg2, cg1, (c-step-dAngle)/atemp);
                
                cbA= valueChange(cb1, cb2, (c-step-dAngle)/atemp);
                cbB= valueChange(cb2, cb1, (c-step-dAngle)/atemp);

                Engine.addModule(new ModuleLine(api, aex1 - cx0,   aey1 - cy0,   aex1 - cx1,  aey1  -cy1,w1,cr2,cg2,cb2,0.5 ));
                Engine.addModule(new ModuleLine(api, aex0 + cx0,   aey1 - cy0,   aex0 + cx1,  aey1  -cy1,w1,crB,cgB,cbB,0.5 ));
                Engine.addModule(new ModuleLine(api, aex0 + cx0,   aey0 + cy0,   aex0 + cx1,  aey0  +cy1,w1,cr1,cg1,cb1,0.5 ));
                Engine.addModule(new ModuleLine(api, aex1 - cx0,  aey0 + cy0,   aex1 - cx1,  aey0  +cy1,w1,crA,cgA,cbA,0.5 ));
            
                break; 
                
                
            case 4:      // round box 2
            
                var r1 = r/2;
                var smallEdge = cornerSize;
                var edge = r1*1.5;// + smallEdge;
            
                Engine.addModule(new ModuleLine(api, ex0+r1-w+1 +edge,ey0,   ex1-r1+w-1 -edge,ey0,w,cr1,cg1,cb1,0 ));
                Engine.addModule(new ModuleLine(api, ex0,ey0+r1-w+1 +edge,   ex0,ey1-r1+w-1 -edge,w,cr1,cg1,cb1,0 ));
                Engine.addModule(new ModuleLine(api, ex1,ey0+r1-w+1 +edge,   ex1,ey1-r1+w-1 -edge,w,cr2,cg2,cb2,0 ));
                Engine.addModule(new ModuleLine(api, ex0+r1-w+1 +edge,ey1,   ex1-r1+w-1 -edge,ey1,w,cr2,cg2,cb2,0 ));

                Engine.addModule(new ModuleLine(api, ex0+r1-w+1 ,ey0 + edge,   ex0+edge+w-1 ,ey0+edge,w,cr1,cg1,cb1,0 ));
                Engine.addModule(new ModuleLine(api, ex1-edge -w+1,ey0 + edge,   ex1-r1+w-1 ,ey0+edge,w,cr1,cg1,cb1,0 ));

                Engine.addModule(new ModuleLine(api, ex0+edge,ey0+r1-w+1 ,   ex0+edge, ey0+edge +w-1 ,w,cr1,cg1,cb1,0 ));
                Engine.addModule(new ModuleLine(api, ex0+edge,ey1-edge -w+1,   ex0+edge,ey1-r1+w-1 ,w,cr1,cg1,cb1,0 ));

                Engine.addModule(new ModuleLine(api, ex1-edge,ey0+r1-w+1 ,   ex1-edge,ey0+edge +w-1,w,cr2,cg2,cb2,0 ));
                Engine.addModule(new ModuleLine(api, ex1-edge,ey1-edge -w+1,   ex1-edge,ey1-r1+w-1 ,w,cr2,cg2,cb2,0 ));
 
 
                Engine.addModule(new ModuleLine(api, ex0+r1-w+1 ,ey1-edge,   ex0+edge +w-1,ey1-edge,w,cr2,cg2,cb2,0 ));
                Engine.addModule(new ModuleLine(api, ex1-edge-w+1 ,ey1-edge,   ex1-r1+w-1 ,ey1-edge,w,cr2,cg2,cb2,0 ));              
                
                
                var cx0 = 0;
                var cy0 = 0;
                var cx1 = 0;
                var cy1 = 0;

                var step = (Math.PI/2)/40;

                for (var c = step; c <= Math.PI/2; c+= step){
                    
                    cx0 = Math.cos(c)*r1;
                    cy0 = Math.sin(c)*r1;
                    cx1 = Math.cos(c-step)*r1;
                    cy1 = Math.sin(c-step)*r1;
                    
                    crA= valueChange(cr1, cr2, c/(Math.PI/2));
                    crB= valueChange(cr2, cr1, c/(Math.PI/2));
                    
                    cgA= valueChange(cg1, cg2, c/(Math.PI/2));
                    cgB= valueChange(cg2, cg1, c/(Math.PI/2));
                    
                    cbA= valueChange(cb1, cb2, c/(Math.PI/2));
                    cbB= valueChange(cb2, cb1, c/(Math.PI/2));

                    Engine.addModule(new ModuleLine(api, ex1 - cx0 -edge,   ey1 - cy0,   ex1 - cx1 -edge,  ey1  -cy1,w,cr2,cg2,cb2,0 ));
                    Engine.addModule(new ModuleLine(api, ex0 + cx0 +edge,   ey1 - cy0,   ex0 + cx1 +edge,  ey1  -cy1,w,crB,cgB,cbB,0 ));
                    Engine.addModule(new ModuleLine(api, ex0 + cx0 +edge,   ey0 + cy0,   ex0 + cx1 +edge,  ey0  +cy1,w,cr1,cg1,cb1,0 ));
                    Engine.addModule(new ModuleLine(api, ex1 - cx0 -edge,  ey0 + cy0,   ex1 - cx1 -edge,  ey0  +cy1,w,crA,cgA,cbA,0 ));
                    
                    Engine.addModule(new ModuleLine(api, ex1 - cx0 ,   ey1 - cy0-edge,   ex1 - cx1,  ey1  -cy1 -edge,w,cr2,cg2,cb2,0 ));
                    Engine.addModule(new ModuleLine(api, ex0 + cx0 ,   ey1 - cy0-edge,   ex0 + cx1,  ey1  -cy1 -edge,w,crB,cgB,cbB,0 ));
                    Engine.addModule(new ModuleLine(api, ex0 + cx0 ,   ey0 + cy0+edge,   ex0 + cx1,  ey0  +cy1 +edge,w,cr1,cg1,cb1,0 ));
                    Engine.addModule(new ModuleLine(api, ex1 - cx0 ,  ey0 + cy0+edge,   ex1 - cx1,  ey0  +cy1 +edge,w,crA,cgA,cbA,0 ));
                }     
                c = Math.PI/2;
                cx0 = Math.cos(c)*r1;
                cy0 = Math.sin(c)*r1;
                cx1 = Math.cos(c-step)*r1;
                cy1 = Math.sin(c-step)*r1;
                
                Engine.addModule(new ModuleLine(api, ex1 - cx0 -edge,   ey1 - cy0,   ex1 - cx1 -edge,  ey1  -cy1,w,cr2,cg2,cb2,0 ));
                Engine.addModule(new ModuleLine(api, ex0 + cx0 +edge,   ey1 - cy0,   ex0 + cx1 +edge,  ey1  -cy1,w,crB,cgB,cbB,0 ));
                Engine.addModule(new ModuleLine(api, ex0 + cx0  +edge,   ey0 + cy0,   ex0 + cx1 +edge,  ey0  +cy1,w,cr1,cg1,cb1,0 ));
                Engine.addModule(new ModuleLine(api, ex1 - cx0 -edge,  ey0 + cy0,   ex1 - cx1 -edge,  ey0  +cy1,w,crA,cgA,cbA,0 ));
                
                Engine.addModule(new ModuleLine(api, ex1 - cx0 ,   ey1 - cy0-edge,   ex1 - cx1,  ey1  -cy1 -edge,w,cr2,cg2,cb2,0 ));
                Engine.addModule(new ModuleLine(api, ex0 + cx0 ,   ey1 - cy0-edge,   ex0 + cx1,  ey1  -cy1 -edge,w,crB,cgB,cbB,0 ));
                Engine.addModule(new ModuleLine(api, ex0 + cx0 ,   ey0 + cy0+edge,   ex0 + cx1,  ey0  +cy1 +edge,w,cr1,cg1,cb1,0 ));
                Engine.addModule(new ModuleLine(api, ex1 - cx0 ,  ey0 + cy0+edge,   ex1 - cx1,  ey0  +cy1 +edge,w,crA,cgA,cbA,0 ));
            
                break; 
                
                
                
            case 5:      // round box 2
            
                Engine.addModule(new ModuleLine(api, ex0+r-w+1,ey0,   ex1-r+w-1,ey0,w,cr1,cg1,cb1,0));
                Engine.addModule(new ModuleLine(api, ex0,ey0+r-w+1,   ex0,ey1-r+w-1,w,cr1,cg1,cb1,0));
                Engine.addModule(new ModuleLine(api, ex1,ey0+r-w+1,   ex1,ey1-r+w-1,w,cr2,cg2,cb2,0));
                Engine.addModule(new ModuleLine(api, ex0+r-w+1,ey1,   ex1-r+w-1,ey1,w,cr2,cg2,cb2,0));
                
                var cx0 = 0;
                var cy0 = 0;
                var cx1 = 0;
                var cy1 = 0;
                
                var step = (Math.PI/2)/60;

                for (var c = step; c <= Math.PI/2; c+= step){
                    
                    cx0 = Math.cos(c)*r;
                    cy0 = Math.sin(c)*r;
                    cx1 = Math.cos(c-step)*r;
                    cy1 = Math.sin(c-step)*r;
                    
                    crA= valueChange(cr1, cr2, c/(Math.PI/2));
                    crB= valueChange(cr2, cr1, c/(Math.PI/2));
                    
                    cgA= valueChange(cg1, cg2, c/(Math.PI/2));
                    cgB= valueChange(cg2, cg1, c/(Math.PI/2));
                    
                    cbA= valueChange(cb1, cb2, c/(Math.PI/2));
                    cbB= valueChange(cb2, cb1, c/(Math.PI/2));
                    
                    Engine.addModule(new ModuleLine(api, ex1 - cx0,   ey1 - cy0,   ex1 - cx1,  ey1  -cy1,w,cr2,cg2,cb2,0));
                    Engine.addModule(new ModuleLine(api, ex0 + cx0,   ey1 - cy0,   ex0 + cx1,  ey1  -cy1,w,crB,cgB,cbB,0));
                    Engine.addModule(new ModuleLine(api, ex0 + cx0,   ey0 + cy0,   ex0 + cx1,  ey0  +cy1,w,cr1,cg1,cb1,0));
                    Engine.addModule(new ModuleLine(api, ex1 - cx0,  ey0 + cy0,   ex1 - cx1,  ey0  +cy1,w,crA,cgA,cbA,0));
                }     
                c = Math.PI/2;
                cx0 = Math.cos(c)*r;
                cy0 = Math.sin(c)*r;
                cx1 = Math.cos(c-step)*r;
                cy1 = Math.sin(c-step)*r;
                
                Engine.addModule(new ModuleLine(api, ex1 - cx0,   ey1 - cy0,   ex1 - cx1,  ey1  -cy1,w,cr2,cg2,cb2,0));
                Engine.addModule(new ModuleLine(api, ex0 + cx0,   ey1 - cy0,   ex0 + cx1,  ey1  -cy1,w,crB,cgB,cbB,0));
                Engine.addModule(new ModuleLine(api, ex0 + cx0,   ey0 + cy0,   ex0 + cx1,  ey0  +cy1,w,cr1,cg1,cb1,0));
                Engine.addModule(new ModuleLine(api, ex1 - cx0,  ey0 + cy0,   ex1 - cx1,  ey0  +cy1,w,crA,cgA,cbA,0));
            
                break; 
                
                
    }

}

function shade(cr, spec)
{
    spec = spec*0.8+0.1;
    if (spec >= 0)
        a = cr + (1-cr)*spec;
    else
        a = cr + cr*spec;
    
    return a;
}

function valueChange(a, b, l)   // l= 0-1     if l=0 .. returns a,  if l=1  returns b   if between, returns between a and b
{
    return (a*(1-l) + b*l);
}




function positionX( shapeType, value, flip, margin, width, repeatN, curveRatio, boxRatio)
{
    var cValue = value;
    if (!flip)
        cValue = repeatN - value;


        return cValue*(outputSizeX/2-margin)/10 + margin;
    
}

function positionY( shapeType, value, flip, margin, width, repeatN, curveRatio, boxRatio)
{

        var cValue = value;
        if (!flip)
            cValue = repeatN - value;

         
        
    switch(shapeType)
    {
        case 1:     // straight
            return margin;
            break;
        
        case 2:     // sine curve
            return Math.sin(cValue* curveRatio * (outputSizeX/2-margin)/ ((outputSizeX+outputSizeY)/10))*width + margin;
            break;
            
        case 3:     // cosine curve
            return Math.cos(cValue* curveRatio *  (outputSizeX/2-margin) /((outputSizeX+outputSizeY)/10))*width + margin;
            break;
            
        
    }
}



var shrinkPreview = 1  // set to 0 to keep preview rectangular

var originOutputSize = RenderAPI.getParameter(kpsSize)

var previewOutputSize = new Vector2(256, 256)
var previewOutputOrigin = new Vector2(0, 0)

if (originOutputSize.x < originOutputSize.y)
{
    previewOutputSize = new Vector2(256 * originOutputSize.x /  originOutputSize.y , 256)
    previewOutputOrigin = new Vector2(128 * (1 - originOutputSize.x /  originOutputSize.y) ,0)
}
else if (originOutputSize.x > originOutputSize.y)
{
    previewOutputSize = new Vector2(256, 256 * originOutputSize.y / originOutputSize.x)
    previewOutputOrigin = new Vector2(0, 128 * (1 - originOutputSize.y /  originOutputSize.x))
}


var shrinkPreview = 1  // set to 0 to keep preview rectangular

var originOutputSize = RenderAPI.getParameter(kpsSize)

var previewSize = 400
var previewOutputSize = new Vector2(previewSize, previewSize)
var previewOutputOrigin = new Vector2(0, 0)

var aspectRatio = originOutputSize.x / originOutputSize.y

if (originOutputSize.x < originOutputSize.y)
{
    if (aspectRatio < 0.5)
        aspectRatio = 0.5
    previewOutputSize = new Vector2(previewSize * aspectRatio , previewSize)
    previewOutputOrigin = new Vector2(previewSize * 0.5 * (1 - aspectRatio) ,0)
}
else if (originOutputSize.x > originOutputSize.y)
{
    if (aspectRatio > 2)
        aspectRatio = 2
    previewOutputSize = new Vector2(previewSize, previewSize / aspectRatio)
    previewOutputOrigin = new Vector2(0, previewSize * 0.5 * (1 - 1 / aspectRatio))
}



function run (api, parameters, scale)
{
    Engine.rand(parameters.arrange);
    // get the size of the output area  
    if (parameters == previewParameters && shrinkPreview)
    {
        api.setParameter (kpsSize, previewOutputSize);
        api.setParameter (kpsOrigin, previewOutputOrigin);
        
        outputSize = previewOutputSize;
        outputOrigin = previewOutputOrigin;
        outputSizeX = outputSize.x;
        outputSizeY = outputSize.y;
        
     }
    else
    {
        var outputSize = api.getParameter(kpsSize);
        var outputOrigin = api.getParameter(kpsOrigin);
        var visibleSize = api.getParameter(kpsVisibleSize);
        var visibleOrigin = api.getParameter(kpsVisibleOrigin);

        if (outputSize.x > visibleSize.x || outputSize.y > visibleSize.y){
            outputSizeX = visibleSize.x;
            outputSizeY = visibleSize.y;
        }else{
            outputSizeX = outputSize.x;
            outputSizeY = outputSize.y;
        }

//Engine.message(outputOrigin.x, "  ", outputOrigin.y, "  ", visibleOrigin.x, "  ", visibleOrigin.y);
        // get the location of the top left corner of the bounding rectangle around the selected area
    }


    if(outputOrigin.x < 0 || outputOrigin.y < 0){
        offsetX = -outputOrigin.x;
        offsetY = -outputOrigin.y;
    }else{
        offsetX = 0;
        offsetY = 0;
    }

    if(outputSizeX < 32 || outputSizeY < 32){
        Engine.message( localize("$$$/DecoScripts/Frame/error1=The selection area must be more than 32 x 32 pixels."))
        return;
    }
    
    
    if (outputSizeX > outputSizeY)
        frameScale = outputSizeY/1500;
    else
        frameScale = outputSizeX/1500;

    switch (parameters.frameNumber)
    {
        
    case 0:                                                     //  simple curly plus dots2
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = parameters.size/10;
                sSizeRandom = 1.5;  // 0..  not random  bigger number is more random
                sSizeRatio = 0.0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // if 1, no fading.  if <1, fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge
                 

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 60;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 4;          // pettern width increase/decrease ratio
                trunk = true;
                tWidth = parameters.width/5;
                trunkType = 2;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 20;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  Math.floor(Engine.rand()*23),     1,       3,      0.8,    false,        1,             47/256,  108/256,  20/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1,5];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/20;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 2;  // 0 .. doesn't change

                tail = 30;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   0.. uniform no matter how big  1.. uniform related to the size,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.1;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0;       // rotation
                angleRandom = 0.5;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = 55;                 // box line width
                
                artStyle = 0;
          
                break;


    case 1:                                                     //  pretty vine
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 1500;

                sSize1 = parameters.size/20;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 0.999;  // if 1, no fading.  if <1, fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 4;   // number of generation
                cgSizeRatio =  -0.1;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.1;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 35;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 3;          // pettern width increase/decrease ratio
                trunk = false
                tWidth = parameters.width/5;
                trunkType = 2;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 20;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  4                                         ,     1,       1.2,      1,    false,        1.5,             0/256,  0/256,  00/256,        0.5];
                sLeaves = [0.00,  6                                           ,   1,       1.5,      1.2,    false,        1,             000/256,  000/256,  0/256,        0.5];

                basePatternNumber = [1,5];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/20;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.1;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 30;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random (random doesn't work)
                patternRatio = 0.05;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.1;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = 100;                 // box line width
                
                artStyle = 0;
          
                break;



    case 2:                                                     //  regular curly
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = parameters.size/10;
                sSizeRandom = 1.5;  // 0..  not random  bigger number is more random
                sSizeRatio = -0.1;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0.2;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 70;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 5;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 2;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 20;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  4                                           ,     1,       1.5,      0.8,    false,        1,             0/256,  000/256,  00/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1,5];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/40;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 30;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.1;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.15;       // rotation
                angleRandom = 0.3;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = 100;                 // box line width
                
                artStyle = 0;
   
                break;



    case 3:                                                     //  party
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = parameters.size/20;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 4;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 65;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 3;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 3;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 10;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  Math.floor(Engine.rand()*23),     1,       3,      0.8,    false,        1,             47/256,  108/256,  20/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1,3];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/40;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 0;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.04;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.0;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = 100;                 // box line width
                
                artStyle = 0;
      
                break;


    case 4:                                                     //  leaves 3
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = parameters.size/10;
                sSizeRandom = 1.5;  // 0..  not random  bigger number is more random
                sSizeRatio = 0.0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 1;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 60;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 4;          // pettern width increase/decrease ratio
                trunk = true;
                tWidth = parameters.width/5;
                trunkType = 2;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 15;        // trunk swinging width

                var leavesRatio = 0.1;
                if (parameters.leafNumber == 0){
                        var leavesRatio = 0;
                        parameters.leafNumber = 1;
                }
                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [leavesRatio,  parameters.leafNumber-1  ,     1,  parameters.leafSize/20,      0.8,    false,        1,             RenderAPI.getParameter(kpsForegroundColor).r, RenderAPI.getParameter(kpsForegroundColor).g, RenderAPI.getParameter(kpsForegroundColor).b,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1,5];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/40;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.2;       // 0.. doesn't change
                sCircleSizeRandom = 0.5;  // 0 .. doesn't change

                tail = 30;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.05;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.0;       // rotation
                angleRandom = 0.5;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;
     
                break;



    case 5:                                                     //  seahorse
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = parameters.size/10;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 1;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 4;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 55;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 100;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 3;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 10;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  3                                            ,     1,       2,      0.8,    false,        1,             47/256,  108/256,  20/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1,5];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/20;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 3;  // 0 .. doesn't change

                tail = 0;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.05;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.1;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;

                break;



    case 6:                                                     //  
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = parameters.size/10;
                sSizeRandom = 1;  // 0..  not random  bigger number is more random
                sSizeRatio = 0.00;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0.5;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 1;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 2;   // number of generation
                cgSizeRatio =  -0.0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 55;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 6;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 3;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 30;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  20                                            ,     1,       2,      0.8,    false,        1,          255/256,  00/256,  00/256,        0.5];
                sLeaves = [0.0,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [3,7];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/20;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 4;  // 0 .. doesn't change

                tail = 0;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.1;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.1;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = true;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;

                break;


    case 7:                                                     //  Curly Dance
                frame = new Frame2();
                frame.setPosition(0,0);

                total = 500;

                sSize1 = parameters.size/10;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 3;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 2;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 45;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 1;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 30;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  Math.floor(Engine.rand()*23),     1,       3,      0.8,    false,        1,             47/256,  108/256,  20/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/120;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 30;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.07;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.0;       // rotation
                angleRandom = 1;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = 100;                 // box line width
                
                artStyle = 0;
      
                break;




    case 8:                                                     //  Curly wave
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = parameters.size/10;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 3;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 2;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 25;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = true;
                tWidth = parameters.width/5;
                trunkType = 1;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 10;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  Math.floor(Engine.rand()*23),     1,       3,      0.8,    false,        1,             47/256,  108/256,  20/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/40;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 6;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.07;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.0;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = 100;                 // box line width
                
                artStyle = 0;
      
                break;



    case 9:                                                     //  spring weed
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = parameters.size/50;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = -3;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 2;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 25;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 3;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 3;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 10;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  Math.floor(Engine.rand()*23),     1,       3,      0.8,    false,        1,             47/256,  108/256,  20/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1,2, 3];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/20;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 30;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.04;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.0;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 10;                                      // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;
   
                break;



    case 10:                                                     //  pop stars
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 1500;

                sSize1 = parameters.size/20;
                sSizeRandom = 1.5;  // 0..  not random  bigger number is more random
                sSizeRatio = 0.0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = -1;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 4;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 40;            // number of points in one spiral
                pType = 1;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 2;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 20;        // trunk swinging width

                var leavesRatio = 0.01;
                if (parameters.leafNumber == 0){
                        var leavesRatio = 0;
                        parameters.leafNumber = 1;
                }

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [leavesRatio,  parameters.leafNumber-1  ,     1,  parameters.leafSize/8,      0.8,    false,        1,             RenderAPI.getParameter(kpsForegroundColor).r, RenderAPI.getParameter(kpsForegroundColor).g, RenderAPI.getParameter(kpsForegroundColor).b,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [4,6];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/40;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.2;       // 0.. doesn't change
                sCircleSizeRandom = 1;  // 0 .. doesn't change

                tail = 0;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.15;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.1;       // rotation
                angleRandom = 0.5;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;

                break;




    case 11:                                                     //  chain
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 1500;

                sSize1 = parameters.size/40;
                sSizeRandom = 1.5;  // 0..  not random  bigger number is more random
                sSizeRatio = 0.0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 2;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 4;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 40;            // number of points in one spiral
                pType = 5;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 2;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 20;        // trunk swinging width


                var leavesRatio = 0.005;
                if (parameters.leafNumber == 0){
                        var leavesRatio = 0;
                        parameters.leafNumber = 1;
                }


                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [leavesRatio,  parameters.leafNumber-1  ,     1,  parameters.leafSize/10,      0.8,    false,        1,             RenderAPI.getParameter(kpsForegroundColor).r, RenderAPI.getParameter(kpsForegroundColor).g, RenderAPI.getParameter(kpsForegroundColor).b,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [4,8];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/15;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.2;       // 0.. doesn't change
                sCircleSizeRandom = 1;  // 0 .. doesn't change

                tail = 20;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.05;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.1;       // rotation
                angleRandom = 0.5;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;

                break;



    case 12:                                                     //  curly vine 2
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = parameters.size/8;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 2;   // number of generation
                cgSizeRatio =  -0.01;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 55;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 3;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 10;        // trunk swinging width

                var leavesRatio = 0.2;
                if (parameters.leafNumber == 0){
                        var leavesRatio = 0;
                        parameters.leafNumber = 1;
                }

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [leavesRatio,  parameters.leafNumber-1  ,     1,  parameters.leafSize/20,      0.8,    false,        1,             RenderAPI.getParameter(kpsForegroundColor).r, RenderAPI.getParameter(kpsForegroundColor).g, RenderAPI.getParameter(kpsForegroundColor).b,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1,3];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/20;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 3;  // 0 .. doesn't change

                tail = 0;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.02;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.1;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;

                break;




    case 13:                                                     //  geometric frame
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = parameters.size/10;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  -0.0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 55;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 1;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 30;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  20                                            ,     1,       2,      0.8,    false,        1,          255/256,  00/256,  00/256,        0.5];
                sLeaves = [0.0,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [6,10];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/20;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 4;  // 0 .. doesn't change

                tail = 0;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.25;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.1;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = true;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;
 
                break;





    case 14:                                                     //   
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = parameters.size/10;
                sSizeRandom = 0.5;  // 0..  not random  bigger number is more random
                sSizeRatio = 0.00;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 1;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 2;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  -0.0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 10;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 3;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 2;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 40;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  20                                            ,     1,       2,      0.8,    false,        1,          255/256,  00/256,  00/256,        0.5];
                sLeaves = [0.0,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1,-2,5,-6];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/20;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.2;       // 0.. doesn't change
                sCircleSizeRandom = 0.5;  // 0 .. doesn't change

                tail = 50;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.075;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = -0.1;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = true;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;

                break;




    case 15:                                                     //   tree with leaves
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = parameters.size/20;
                sSizeRandom = 0.5;  // 0..  not random  bigger number is more random
                sSizeRatio = 0.00;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 1;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 2;   // number of generation
                cgSizeRatio =  0.0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 20;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 3;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 2;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 40;        // trunk swinging width

                var leavesRatio = 0.2;
                if (parameters.leafNumber == 0){
                        var leavesRatio = 0;
                        parameters.leafNumber = 1;
                }


                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [leavesRatio,  parameters.leafNumber-1  ,     1,  parameters.leafSize/10,      0.8,    false,        1,         RenderAPI.getParameter(kpsForegroundColor).r, RenderAPI.getParameter(kpsForegroundColor).g, RenderAPI.getParameter(kpsForegroundColor).b,        0.5];
                sLeaves = [0.0,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1,-2,5];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/40;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.15;       // 0.. doesn't change
                sCircleSizeRandom = 1.5;  // 0 .. doesn't change

                tail = 50;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.075;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = -0.1;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;

                break;




        
     case 16 :
                // simple curve lines
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

               total = 500;

                sSize1 = parameters.size/10;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // if 1, no fading.  if <1, fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 35;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 1;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 30;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  Math.floor(Engine.rand()*23),     1,       3,      0.8,    false,        1,             47/256,  108/256,  20/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1,5];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/50;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 30;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   0.. uniform no matter how big  1.. uniform related to the size,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.07;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.0;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = 100;                 // box line width
                
                artStyle = 0;
    
                break;
        
        
  


    case 17:                                                     // leaves1
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 1500;

                sSize1 = 1;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 1;   // number of generation
                cgSizeRatio =  -0.02;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.2;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 3;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 3;          // pettern width increase/decrease ratio
                trunk = true
                tWidth = parameters.width/5;
                trunkType = 2;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = parameters.size/10 * 15;        // trunk swinging width

                var leavesRatio = 5;
                if (parameters.leafNumber == 0){
                        var leavesRatio = 0;
                        parameters.leafNumber = 1;
                }
                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [leavesRatio,  parameters.leafNumber-1  ,     1,  parameters.leafSize/20,      1,    false,        2.5,             RenderAPI.getParameter(kpsForegroundColor).r, RenderAPI.getParameter(kpsForegroundColor).g, RenderAPI.getParameter(kpsForegroundColor).b,        0.5];
                sLeaves = [0.0,  1                                           ,   1,       0.5,      1.2,    false,        1,             RenderAPI.getParameter(kpsForegroundColor).r, RenderAPI.getParameter(kpsForegroundColor).g, RenderAPI.getParameter(kpsForegroundColor).b,        0.5];

                basePatternNumber = [-5];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/20;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.1;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 0;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random (random doesn't work)
                patternRatio = 0.1;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.0;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;
      
                break;







    case 18:                                                     //  leaves 2
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = 2.5;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0.0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 3;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 20;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 4;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 2;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = parameters.size/10 * 15;        // trunk swinging width

                var leavesRatio = 0.1;
                if (parameters.leafNumber == 0){
                        var leavesRatio = 0;
                        parameters.leafNumber = 1;
                }
                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [leavesRatio,  parameters.leafNumber-1  ,     1,  parameters.leafSize/10,      0.8,    false,        1,             RenderAPI.getParameter(kpsForegroundColor).r, RenderAPI.getParameter(kpsForegroundColor).g, RenderAPI.getParameter(kpsForegroundColor).b,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1,5];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/20;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.2;       // 0.. doesn't change
                sCircleSizeRandom = 0;  // 0 .. doesn't change

                tail = 5;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.075;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.0;       // rotation
                angleRandom = 0.5;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;

                break;





    case 19:                                                     //   
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = parameters.size/10;
                sSizeRandom = 0.5;  // 0..  not random  bigger number is more random
                sSizeRatio = 0.00;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0.2;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 1;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  0.0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 40;            // number of points in one spiral
                pType = 1;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 12;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 2;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 40;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.0,  3                                            ,     1,       1.2,      0.8,    false,        1,          40/256,  113/256,  18/256,        0.5];
                sLeaves = [0.0,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1,5];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/7;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.15;       // 0.. doesn't change
                sCircleSizeRandom = 0.5;  // 0 .. doesn't change

                tail = 10;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.04;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = -0.1;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;
     
                break;





    case 20:                                                     //  mustache
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 80;

                sSize1 = parameters.size/10;
                sSizeRandom = 0.5;  // 0..  not random  bigger number is more random
                sSizeRatio = 0.00;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0.8;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 0.99;  // fading color of the curl
                cContinuous = 1;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 1;   // number of generation
                cgSizeRatio =  0.0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 20;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 2;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 40;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.0,  3                                            ,     1,       0.8,      0.8,    false,        1,          40/256,  113/256,  18/256,        0.5];
                sLeaves = [0.0,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1,5];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/20;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.15;       // 0.. doesn't change
                sCircleSizeRandom = 0.5;  // 0 .. doesn't change

                tail = 10;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.12;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = -0.1;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;

                break;






    case 21:                                                     //  spread flowers
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = parameters.size/10;
                sSizeRandom = 1.5;  // 0..  not random  bigger number is more random
                sSizeRatio = -0.1;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0.2;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // if 1, no fading.  if <1, fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = false;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 40;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 5;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 2;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 20;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  10                                           ,     1,       1.5,      0.8,    false,        1,             0/256,  000/256,  00/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1,5];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/20;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 30;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.1;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.25;       // rotation
                angleRandom = 0.3;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = 100;                 // box line width
                
                artStyle = 0;
      
                break;






    case 22:                                                     //  aligned flower 1
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = parameters.size/10;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = false;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  -0.01;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 55;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 3;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 10;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0,  parameters.leafNumber-1  ,     1,  parameters.leafSize/20,      0.8,    true,        1,             RenderAPI.getParameter(kpsForegroundColor).r, RenderAPI.getParameter(kpsForegroundColor).g, RenderAPI.getParameter(kpsForegroundColor).b,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1,3];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/20;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.1;       // 0.. doesn't change
                sCircleSizeRandom = 3;  // 0 .. doesn't change

                tail = 0;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.04;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.1;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = true;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;

                break;






    case 23:                                                     //  focused objects
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 1500;

                sSize1 = parameters.size/10;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 0.99;  // fading color of the curl
                cContinuous = 6;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = false;       // draw the curve or not

                cGenerationN = 5;   // number of generation
                cgSizeRatio =  -0.02;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.2;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 2;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 12;          // pettern width increase/decrease ratio
                trunk = false
                tWidth = parameters.width/5;
                trunkType = 2;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 20;        // trunk swinging width


                var leavesRatio = 0.5;
                if (parameters.leafNumber == 0){
                        var leavesRatio = 0;
                        parameters.leafNumber = 1;
                }


                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [leavesRatio,  parameters.leafNumber-1  ,     1,  parameters.leafSize/15,      1,    false,        0.5,             RenderAPI.getParameter(kpsForegroundColor).r, RenderAPI.getParameter(kpsForegroundColor).g, RenderAPI.getParameter(kpsForegroundColor).b,        0.5];
                sLeaves = [0.0,  1                                           ,   1,       0.5,      1.2,    false,        1,             000/256,  000/256,  0/256,        0.5];

                basePatternNumber = [14];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/20;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.1;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 0;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random (random doesn't work)
                patternRatio = 0.05;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.05;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;
 
                break;






    case 24:                                                     // snow
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = parameters.size/40;
                sSizeRandom = 0.5;  // 0..  not random  bigger number is more random
                sSizeRatio = 0.00;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0.8;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 0.99;  // fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = false;       // draw the curve or not

                cGenerationN = 6;   // number of generation
                cgSizeRatio =  0.0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 30;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 2;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 40;        // trunk swinging width


                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.0,  3                                            ,     1,       0.8,      0.8,    false,        1,          40/256,  113/256,  18/256,        0.5];
                sLeaves = [0.0,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1,5];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/20;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.15;       // 0.. doesn't change
                sCircleSizeRandom = 0.5;  // 0 .. doesn't change

                tail = 10;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.04;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = -0.1;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;

                break;





    case 25:                                                     //  flurry
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 100;

                sSize1 = parameters.size/40;
                sSizeRandom = 0.0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0.00;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0.8;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = false;       // draw the curve or not

                cGenerationN = 1;   // number of generation
                cgSizeRatio =  0.0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 20;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 2;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 20;        // trunk swinging width

                var leavesRatio = 0.005;
                if (parameters.leafNumber == 0){
                        var leavesRatio = 0;
                        parameters.leafNumber = 1;
                }
            
                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [leavesRatio,  parameters.leafNumber-1  ,     1,  parameters.leafSize/20,      0.8,    false,        1,          RenderAPI.getParameter(kpsForegroundColor).r, RenderAPI.getParameter(kpsForegroundColor).g, RenderAPI.getParameter(kpsForegroundColor).b,        0.5];
                sLeaves = [0.0,  5,                                               1,       3,      0.8,    false,        1,             242/256,  173/256,  52/256,        0.5];

                basePatternNumber = [1,5];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/20;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.15;       // 0.. doesn't change
                sCircleSizeRandom = 0.5;  // 0 .. doesn't change

                tail = 0;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.1;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.1;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;

     
                break;






    case 26:                                                     //  check marks
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 1500;

                sSize1 = parameters.size/10;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 12;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 5;   // number of generation
                cgSizeRatio =  -0.02;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.2;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 2;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 3;          // pettern width increase/decrease ratio
                trunk = false
                tWidth = parameters.width/5;
                trunkType = 2;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 20;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.0,  12                                              ,     1,       0.5,      1,    false,        2.5,             0/256,  0/256,  00/256,        0.5];
                sLeaves = [0.0,  1                                           ,   1,       0.5,      1.2,    false,        1,             000/256,  000/256,  0/256,        0.5];

                basePatternNumber = [14,16];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/20;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.1;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 0;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random (random doesn't work)
                patternRatio = 0.05;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.1;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;
   
                break;






    case 27:                                                     //  focused lines1
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 1500;

                sSize1 = parameters.size/10;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 6;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 5;   // number of generation
                cgSizeRatio =  -0.02;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.2;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 2;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 12;          // pettern width increase/decrease ratio
                trunk = false
                tWidth = parameters.width/5;
                trunkType = 2;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 20;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.0,  12                                              ,     1,       0.5,      1,    false,        2.5,             0/256,  0/256,  00/256,        0.5];
                sLeaves = [0.0,  1                                           ,   1,       0.5,      1.2,    false,        1,             000/256,  000/256,  0/256,        0.5];

                basePatternNumber = [14,18];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/20;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.1;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 0;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random (random doesn't work)
                patternRatio = 0.05;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.05;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;

                break;







    case 28:                                                     //  focused line2
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 1500;

                sSize1 = parameters.size/10;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 10;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 20;   // number of generation
                cgSizeRatio =  -0.04;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.2;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 2;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 7;          // pettern width increase/decrease ratio
                trunk = false
                tWidth = parameters.width/5;
                trunkType = 2;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 20;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.0,  12                                              ,     1,       0.5,      1,    false,        2.5,             0/256,  0/256,  00/256,        0.5];
                sLeaves = [0.0,  1                                           ,   1,       0.5,      1.2,    false,        1,             000/256,  000/256,  0/256,        0.5];

                basePatternNumber = [1,5];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/20;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.1;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 0;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random (random doesn't work)
                patternRatio = 0.05;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.0;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;

                break;






    case 29:                                                     //  focused line3
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 1500;

                sSize1 = parameters.size/10;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 8;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 8;   // number of generation
                cgSizeRatio =  -0.02;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.2;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 2;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 12;          // pettern width increase/decrease ratio
                trunk = false
                tWidth = parameters.width/5;
                trunkType = 2;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 50;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.0,  12                                              ,     1,       0.5,      1,    false,        2.5,             0/256,  0/256,  00/256,        0.5];
                sLeaves = [0.0,  1                                           ,   1,       0.5,      1.2,    false,        1,             000/256,  000/256,  0/256,        0.5];

                basePatternNumber = [2,6];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/20;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.1;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 0;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random (random doesn't work)
                patternRatio = 0.075;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.0;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;
     
                break;







    case 30:                                                     //  stones
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 1500;

                sSize1 = parameters.size/10;
                sSizeRandom = 1.5;  // 0..  not random  bigger number is more random
                sSizeRatio = 0.0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 7;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 4;   // number of generation
                cgSizeRatio =  -0.1;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 30;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 2;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 20;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.000,  20,                                                1,       2,      0.8,    false,        1,             0/256,  0/256,  00/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [-4,-8];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/20;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.2;       // 0.. doesn't change
                sCircleSizeRandom = 1;  // 0 .. doesn't change

                tail = 20;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.05;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.1;       // rotation
                angleRandom = 0.5;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;
         
                break;






    case 31:                                                     //  focused line 4
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = parameters.size/10;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 1;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 4;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 5;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 120;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 3;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 10;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  3                                            ,     1,       2,      0.8,    false,        1,             47/256,  108/256,  20/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [3];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/20;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.2;       // 0.. doesn't change
                sCircleSizeRandom = 3;  // 0 .. doesn't change

                tail = 0;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.05;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.1;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;
 
                break;








    case 32:                                                     //   flowers
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = parameters.size/10;
                sSizeRandom = 1;  // 0..  not random  bigger number is more random
                sSizeRatio = 0.00;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0.5;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  -0.0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 10;            // number of points in one spiral
                pType = 1;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 12;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 3;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 30;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  20                                            ,     1,       2,      0.8,    false,        1,          255/256,  00/256,  00/256,        0.5];
                sLeaves = [0.0,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1,2,3,4,5,6,7,8];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/20;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 0;  // 0 .. doesn't change

                tail = 0;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.1;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = -0.1;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = true;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;
   
                break;











    case 33:                                                     //   spread flower 3
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = parameters.size/10;
                sSizeRandom = 0.5;  // 0..  not random  bigger number is more random
                sSizeRatio = 0.00;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 1;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 4;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  0.0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 2;            // number of points in one spiral
                pType = 1;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 12;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 2;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 40;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0,  parameters.leafNumber-1  ,     1,  parameters.leafSize/20,      0.8,    false,        1,          RenderAPI.getParameter(kpsForegroundColor).r, RenderAPI.getParameter(kpsForegroundColor).g, RenderAPI.getParameter(kpsForegroundColor).b,        0.5];
                sLeaves = [0.0,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1,-2,3, -4, 5,-6, 7, -8];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/20;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.2;       // 0.. doesn't change
                sCircleSizeRandom = 0.5;  // 0 .. doesn't change

                tail = 20;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.02;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = -0.1;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;

                break;













    case 34:                                                     //  aligned flowers
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = parameters.size/10;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = false;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 1;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 1;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 10;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  Math.floor(Engine.rand()*23),     1,       3,      0.8,    false,        1,             47/256,  108/256,  20/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = parameters.flowerNumber+1;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = parameters.flowerSize/20;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 6;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.07;  // how often it happens;

                angle = parameters.angle; //1.9*3.14;
                angleRatio = 0.0;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 50;                 // box round
                tbGap = parameters.size/10;
                tbWidth  = parameters.width*2/5;                 // box line width
                
                artStyle = 0;

                break;






    case 35:                                                     //  double box
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = 1;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = false;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 1;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 1;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 10;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  Math.floor(Engine.rand()*23),     1,       3,      0.8,    false,        1,             47/256,  108/256,  20/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = 0;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = 1;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 6;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.07;  // how often it happens;

                angle = 1.9*3.14;
                angleRatio = 0.0;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 1; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = parameters.angle/360;                  // box round
                tbGap = parameters.size/4;
                tbWidth  = parameters.width/5;                 // box line width
                
                artStyle = 0;

                break;



 
  


    case 36:                                                     //  double round box
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = 1;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = false;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 1;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 1;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 10;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  Math.floor(Engine.rand()*23),     1,       3,      0.8,    false,        1,             47/256,  108/256,  20/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = 0;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = 1;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 6;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.07;  // how often it happens;

                angle = 1.9*3.14;
                angleRatio = 0.0;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 4; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = parameters.angle/360;                  // box round
                tbGap = parameters.size/4;
                tbWidth  = parameters.width/5;                 // box line width
                
                artStyle = 0;

                break;


    case 37:                                                     //  flipped round box
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = 1;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = false;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 1;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 1;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 10;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  Math.floor(Engine.rand()*23),     1,       3,      0.8,    false,        1,             47/256,  108/256,  20/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = 0;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = 1;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 6;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.07;  // how often it happens;

                angle = 1.9*3.14;
                angleRatio = 0.0;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 6; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = parameters.angle/360;                  // box round
                tbGap = parameters.size/4;
                tbWidth  = parameters.width/5;                 // box line width
                
                artStyle = 0;

                break;

    case 38:                                                     //  flipped round box
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = 1;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = false;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 1;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 1;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 10;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  Math.floor(Engine.rand()*23),     1,       3,      0.8,    false,        1,             47/256,  108/256,  20/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = 0;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = 1;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 6;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.07;  // how often it happens;

                angle = 1.9*3.14;
                angleRatio = 0.0;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 5; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = parameters.angle/360;                  // box round
                tbGap = parameters.size/4;
                tbWidth  = parameters.width/5;                 // box line width
                
                artStyle = 0;

                break;

    case 39:                                                     //  doual flipped round box
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = 1;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = false;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 1;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 1;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 10;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  Math.floor(Engine.rand()*23),     1,       3,      0.8,    false,        1,             47/256,  108/256,  20/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = 0;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = 1;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 6;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.07;  // how often it happens;

                angle = 1.9*3.14;
                angleRatio = 0.0;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 8; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = parameters.angle/360;                  // box round
                tbGap = parameters.size/4;
                tbWidth  = parameters.width/5;                 // box line width
                
                artStyle = 0;

                break;

    case 40:                                                     //  doual flipped round box
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = 1;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = false;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 1;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 1;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 10;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  Math.floor(Engine.rand()*23),     1,       3,      0.8,    false,        1,             47/256,  108/256,  20/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = 0;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = 1;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 6;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.07;  // how often it happens;

                angle = 1.9*3.14;
                angleRatio = 0.0;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 7; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = parameters.angle/360;                  // box round
                tbGap = parameters.size/4;
                tbWidth  = parameters.width/5;                 // box line width
                
                artStyle = 0;

                break;





    case 41:                                                     //  art frame1
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = 1;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = false;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 1;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 1;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 10;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  Math.floor(Engine.rand()*23),     1,       3,      0.8,    false,        1,             47/256,  108/256,  20/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = 0;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = 1;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 6;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.07;  // how often it happens;

                angle = 1.9*3.14;
                angleRatio = 0.0;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = parameters.angle/360;                  // box round
                tbGap = parameters.size/4;
                tbWidth  = parameters.width/5;                 // box line width
                
                artStyle = 1;

                break;



    case 42:                                                     //  art frame2
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = 1;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = false;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 1;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 1;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 10;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  Math.floor(Engine.rand()*23),     1,       3,      0.8,    false,        1,             47/256,  108/256,  20/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = 0;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = 1;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 6;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.07;  // how often it happens;

                angle = 1.9*3.14;
                angleRatio = 0.0;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = parameters.angle/360;                  // box round
                tbGap = parameters.size/4;
                tbWidth  = parameters.width/5;                 // box line width
                
                artStyle = 4;

                break;



    case 43:                                                     //  art frame3
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = 1;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = false;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 1;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 1;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 10;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  Math.floor(Engine.rand()*23),     1,       3,      0.8,    false,        1,             47/256,  108/256,  20/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = 0;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = 1;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 6;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.07;  // how often it happens;

                angle = 1.9*3.14;
                angleRatio = 0.0;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = parameters.angle/360;                  // box round
                tbGap = parameters.size/4;
                tbWidth  = parameters.width/5;                 // box line width
                
                artStyle = 6;

                break;



    case 44:                                                     //  art frame4
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = 1;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = false;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 1;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 1;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 10;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  Math.floor(Engine.rand()*23),     1,       3,      0.8,    false,        1,             47/256,  108/256,  20/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = 0;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = 1;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 6;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.07;  // how often it happens;

                angle = 1.9*3.14;
                angleRatio = 0.0;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = parameters.angle/360;                  // box round
                tbGap = parameters.size/4;
                tbWidth  = parameters.width/5;                 // box line width
                
                artStyle = 5;

                break;



    case 45:                                                     //  art frame 5
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = 1;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = false;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 1;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 1;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 10;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  Math.floor(Engine.rand()*23),     1,       3,      0.8,    false,        1,             47/256,  108/256,  20/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = 0;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = 1;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 6;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.07;  // how often it happens;

                angle = 1.9*3.14;
                angleRatio = 0.0;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = parameters.angle/360;                  // box round
                tbGap = parameters.size/4;
                tbWidth  = parameters.width/5;                 // box line width
                
                artStyle = 8;

                break;



    case 46:                                                     //  art frame
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = 1;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = false;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 1;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 1;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 10;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  Math.floor(Engine.rand()*23),     1,       3,      0.8,    false,        1,             47/256,  108/256,  20/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = 0;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = 1;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 6;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.07;  // how often it happens;

                angle = 1.9*3.14;
                angleRatio = 0.0;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = parameters.angle/360;                  // box round
                tbGap = parameters.size/4;
                tbWidth  = parameters.width/5;                 // box line width
                
                artStyle = 7;

                break;



    case 47:                                                     //  art frame
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

                total = 500;

                sSize1 = 1;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = false;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 1;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = parameters.width/5;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = parameters.width/5;
                trunkType = 1;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 10;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.00,  Math.floor(Engine.rand()*23),     1,       3,      0.8,    false,        1,             47/256,  108/256,  20/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = 0;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = 1;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 6;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   1.. uniform,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.07;  // how often it happens;

                angle = 1.9*3.14;
                angleRatio = 0.0;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = parameters.angle/360;                  // box round
                tbGap = parameters.size/4;
                tbWidth  = parameters.width/5;                 // box line width
                
                artStyle = 7;

                break;





     default :
                // simple curve lines
                frame = new Frame2();
                //frame.rotateDeg(90);
                frame.setPosition(0,0);

               total = 500;

                sSize1 = 2.5;
                sSizeRandom = 0;  // 0..  not random  bigger number is more random
                sSizeRatio = 0;    //  positive number .. size becomes bigger as it goes.  negative number .. size becomes smaller
                sSizeCos = 0;        // size changes based on Math.cos    If it is 0, it doesn't change.

                cColorFade = 1;  // if 1, no fading.  if <1, fading color of the curl
                cContinuous = 0;  // when this is positive, curls continue for the number of times,  end of the curl, leaf happens.  if negative, it doesn't happen.
                curveVisible = true;       // draw the curve or not

                cGenerationN = 0;   // number of generation
                cgSizeRatio =  0;  // the size of its child   0.. doesn't change
                cgSizeRandom = 0.5;  // 0.. doesn't change

                //var sRotate = 0.01;      // rotate the curl as it goes
                //var sRotateRandom = 0;  // random rotate

                flip = parameters.flip;                // which way to start  false.. center,  true.. edge

                curveRatio = 1.2;
                marginRatio = (parameters.frameMargin-1)/222;

                spiral = 35;            // number of points in one spiral
                pType = 2;            // pattern type  when it is 3, spiral should be less than 37
                                             // 0.. uniform  1.. increase the size  2.. decrease the size  
                                             // 3 increase and decrease the size 4 decrease and increase the size  5  cosine  6  random
                ipWidth = 2;          // initial pettern width
                pWidth = 2;          // pettern width increase/decrease ratio
                trunk = false;
                tWidth = 2;
                trunkType = 1;      // 1.. straight   2.. sign curve   3.. cosine curve
                fWidth = 30;        // trunk swinging width

                //var leavesType = 1;     //  0.. one side  1.. both side
                //                      ratio0  pattern1,                                             type2  size3, width4 reverse5    size Random6      R7             G8            B9          tone random10
                leaves = [0.01,  Math.floor(Engine.rand()*23),     1,       3,      0.8,    false,        1,             47/256,  108/256,  20/256,        0.5];
                sLeaves = [0.00,  Math.floor(Engine.rand()*8),   1,       3,      0.8,    false,        1,             255/256,  33/256,  117/256,        0.5];

                basePatternNumber = [1,5];  // how curly patterns are placed at once.  each direction has 45 degree increment
                                                                                    // negative number flips the shape
                sCircle = 0;        // 0.. non   1.. Cap    2..  circle on the end of the curl  3- 19.. flower patterns
                sCircleSize = 2;   // circle size  1.. regular size    ignored if it is for cap
                sCircleSizeRatio = 0.05;       // 0.. doesn't change
                sCircleSizeRandom = 5;  // 0 .. doesn't change

                tail = 30;                   // extra length in end of the curls when cContinuous > 0

                patternPattern = 1;  // how pattern happens   0.. uniform no matter how big  1.. uniform related to the size,  2.. happens earlier  3.. happens later 4.. random
                patternRatio = 0.07;  // how often it happens;

                angle = 2*3.14;
                angleRatio = 0.0;       // rotation
                angleRandom = 0;     // angle randomness   0.. no randomness

                objAngleSnap = false;    // when true, object snaps to 90 degree

                tBoxStyle = 0; // 0.. non, 1.. simple box,  2.. double box,  3.. double box2   4.. round, 5.. flipped round1, 6 flipped round2, 7.. dual round1  8.. dual round2
                tbRadius = 150;                 // box round
                tbGap = parameters.size/4;
                tbWidth  = 100;                 // box line width
                
                artStyle = 1;

                break;

    }

    cColorFade = 1-Math.pow(parameters.fade/100, cGenerationN+1);



    if(!curveVisible && sCircle ==1)
        sCircle = 0;

    angle *= Math.PI/180;

    sColor = [ parameters.vcolor[0], parameters.vcolor[1], parameters.vcolor[2]];
    tbr = parameters.vcolor[0];
    tbg = parameters.vcolor[1];
    tbb = parameters.vcolor[2]; 
    
    scColor = [ parameters.fcolor[0], parameters.fcolor[1], parameters.fcolor[2]];   // circle and flower color
    
    leaves[7] = parameters.lcolor[0];
    leaves[8] = parameters.lcolor[1];
    leaves[9] = parameters.lcolor[2];
    


    //var side = 1;

    var leavesSize = sLeaves[3];
    var pattern = sLeaves[1];
    var width = sLeaves[4];
    var reverse = sLeaves[5];
    var leavesRandom = sLeaves[6];

    var x0 = sShape[pattern][0];
    var y0 = sShape[pattern][1];
    
    var renderTotal = 0;
    
    
    if (outputSizeX > outputSizeY){
        realMargin = outputSizeY * marginRatio;
        var smallerSize = outputSizeY - realMargin;
    }else{
        realMargin = outputSizeX * marginRatio;
        var smallerSize = outputSizeX - realMargin;
    }
    margin = marginRatio * 1500;         // convert the ratio to pixel

    var slPoints = new Array();

    for (i = sShape[pattern].length-2; i >= 0; i -= 2){

        var x1=  (sShape[pattern][i]- x0)* width;
        var y1 = (sShape[pattern][i+1] - y0);
        
        slPoints.push(new Vector3(x1, y1));
    }    

    if (tBoxStyle>0)
    {
        var base = (outputSizeX+outputSizeY)/10;
        var tBoxSize = parameters.size*base/500;
        if (parameters.nlines <= 1)
            var step = tBoxSize + 1;
        else
            var step = tBoxSize / (parameters.nlines-1);
        for (i= 0; i <= tBoxSize; i +=step)
        {
            if (parameters.flip)      
            {
                realMargin1 = realMargin + (0.15 * (i + Math.sin(Math.PI*i/tBoxSize)) * parameters.size);     
                tbWidth1 = tbWidth + parameters.nlines*i/tBoxSize;
            } else {
                realMargin1 = realMargin + (0.15 * i * parameters.size);     
                tbWidth1 = tbWidth;
            }

            tbRadius1 = tbRadius * smallerSize;

            switch(tBoxStyle)
            {
                case 0:
                    break;
                case 1:
                    tBox(api, 0, tbGap*4*frameScale, realMargin1, realMargin1, outputSizeX - realMargin1, outputSizeY - realMargin1, tbWidth1*frameScale, tbRadius1, tbr,tbg,tbb, offsetX, offsetY, parameters.size);
                    break;
                case 2:
                    tBox(api, 0, tbGap*4*frameScale, realMargin1, realMargin1, outputSizeX - realMargin1, outputSizeY - realMargin1, tbWidth1*frameScale, tbRadius1, tbr,tbg,tbb, offsetX, offsetY, parameters.size);
                    tBox(api, 0, tbGap*4*frameScale, realMargin1+tbGap*4*frameScale, realMargin1+tbGap*4*frameScale, outputSizeX - realMargin1 - tbGap*4*frameScale, outputSizeY - realMargin1 - tbGap*4*frameScale, tbWidth1*frameScale / 2, tbRadius1, tbr,tbg,tbb, offsetX, offsetY, parameters.size);
                    break;
                case 3:
                    tBox(api, 1, tbGap*4*frameScale, realMargin1, realMargin1, outputSizeX - realMargin1, outputSizeY - realMargin1, tbWidth1*frameScale, tbRadius1, tbr,tbg,tbb, offsetX, offsetY, parameters.size);
                    break;
                case 4:
                    tbRadius1 = tbRadius * smallerSize - (0.15 * (i + Math.sin(Math.PI*i/tBoxSize)) * parameters.size);
                    if (tbRadius1 < tbWidth)
                        tbRadius1 = tbWidth;
                    tBox(api, 2, tbGap*4*frameScale, realMargin1, realMargin1, outputSizeX - realMargin1, outputSizeY - realMargin1, tbWidth1*frameScale, tbRadius1, tbr,tbg,tbb, offsetX, offsetY, parameters.size);
                    break;    
                case 5:
                    tbRadius1 = tbRadius * smallerSize - (0.15 * (i + Math.sin(Math.PI*i/tBoxSize)) * parameters.size)/2;
                    if (tbRadius1 < 0)
                        tbRadius1 = 0;
                    tBox(api, 3, tbGap*4*frameScale, realMargin1, realMargin1, outputSizeX - realMargin1, outputSizeY - realMargin1, tbWidth1*frameScale, tbRadius1, tbr,tbg,tbb, offsetX, offsetY, parameters.size);
                    break;
                case 6:
                    tbRadius1 = tbRadius * smallerSize + (0.075 * (i + Math.sin(Math.PI*i/tBoxSize)) * parameters.size)/2;
                    tBox(api, 3, tbGap*4*frameScale, realMargin1, realMargin1, outputSizeX - realMargin1, outputSizeY - realMargin1, tbWidth1*frameScale, tbRadius1, tbr,tbg,tbb, offsetX, offsetY, parameters.size);
                    break;
                case 7:
                    tbRadius1 = tbRadius * smallerSize - (0.15 * (i + Math.sin(Math.PI*i/tBoxSize)) * parameters.size);
                    if (tbRadius1 < 0)
                        tbRadius1 = 0;

                    tBox(api, 4, tbGap*4*frameScale, realMargin1, realMargin1, outputSizeX - realMargin1, outputSizeY - realMargin1, tbWidth1*frameScale, tbRadius1, tbr,tbg,tbb, offsetX, offsetY, parameters.size);
                    break;

                case 8:
                    tbRadius1 = tbRadius * smallerSize + (0.15 * (i + Math.sin(Math.PI*i/tBoxSize)) * parameters.size)/2;
                    tBox(api, 4, tbGap*4*frameScale, realMargin1, realMargin1, outputSizeX - realMargin1, outputSizeY - realMargin1, tbWidth1*frameScale, tbRadius1, tbr,tbg,tbb, offsetX, offsetY, parameters.size);
                    break;
            }  
        }
    }


//  art frame
    if(artStyle > 0)
    {
        var base = (outputSizeX+outputSizeY)/2;
        var artFrameSize = parameters.size*base/500;
        var step = 1;//parameters.size / parameters.nlines;
        var specArray = new Array();
        makeSpecArray(specArray, parameters.nlines);
        
        for (i= 0; i < artFrameSize; i +=step)
        {

            realMargin1 = realMargin + i;//(realMargin*0.002 * i  * parameters.size);
            tbWidth1 = step*1.0;//tbWidth;
            tbRadius1 = tbRadius * smallerSize;
            
 //           spec = Math.sin(2*Math.PI*i/(parameters.nlines * step));
            spec = getSpecArray(specArray,i/artFrameSize);
            
            if ( i==0)
            {
                var originalMargin = realMargin1;
                var originalR = tbRadius1;
                //Engine.message(originalMargin, "  ", originalR,"  ", tbRadius, "  ", smallerSize);
            }
//        Engine.message (originalMargin, "  ", realMargin1);

            switch(artStyle)
            {
                case 0:
                    break;
                case 1:
                    artBox(api, 0, parameters.flip, originalMargin, originalMargin, outputSizeX - originalMargin, outputSizeY- originalMargin , realMargin1, realMargin1, outputSizeX - realMargin1, outputSizeY - realMargin1, tbWidth1, tbRadius1, originalR, tbr,tbg,tbb, offsetX, offsetY, parameters.size, spec);
                    break;
                case 2:
                    artBox(api, 0, parameters.flip, originalMargin, originalMargin, outputSizeX - originalMargin, outputSizeY- originalMargin, realMargin1, realMargin1, outputSizeX - realMargin1, outputSizeY - realMargin1, tbWidth1, tbRadius1, tbr,tbg,tbb, offsetX, offsetY, parameters.size, spec);
 //                   artBox(api, 0, parameters.flip, originalMargin, realMargin1+tbGap*4*frameScale, realMargin1+tbGap*4*frameScale, outputSizeX - realMargin1 - tbGap*4*frameScale, outputSizeY - realMargin1 - tbGap*4*frameScale, tbWidth1*frameScale / 2, tbRadius1, tbr,tbg,tbb, offsetX, offsetY, parameters.size, spec);
                    break;
                case 3:
                    artBox(api, 1, parameters.flip, originalMargin, originalMargin, outputSizeX - originalMargin, outputSizeY- originalMargin, realMargin1, realMargin1, outputSizeX - realMargin1, outputSizeY - realMargin1, tbWidth1, tbRadius1, originalR, tbr,tbg,tbb, offsetX, offsetY, parameters.size, spec);
                    break;
                case 4:
                    tbRadius1 = tbRadius * smallerSize - i;//(realMargin*0.002 * i * parameters.size);
                    if (tbRadius1 < tbWidth)
                        tbRadius1 = tbWidth;
                    artBox(api, 2, parameters.flip, originalMargin, originalMargin, outputSizeX - originalMargin, outputSizeY- originalMargin, realMargin1, realMargin1, outputSizeX - realMargin1, outputSizeY - realMargin1, tbWidth1, tbRadius1, originalR, tbr,tbg,tbb, offsetX, offsetY, parameters.size, spec);
                    break;    
                case 5:
                    tbRadius1 = tbRadius * smallerSize - i;//(realMargin*0.002 * i * parameters.size);
                    if (tbRadius1 < 0)
                        tbRadius1 = 0;
                    artBox(api, 5, parameters.flip, originalMargin, originalMargin, outputSizeX - originalMargin, outputSizeY- originalMargin, realMargin1, realMargin1, outputSizeX - realMargin1, outputSizeY - realMargin1, tbWidth1, tbRadius1, originalR, tbr,tbg,tbb, offsetX, offsetY, parameters.size, spec);
                    break;
                case 6:
                    tbRadius1 = tbRadius * smallerSize + i;//(realMargin*0.0005 * i * parameters.size);
                    artBox(api, 3, parameters.flip, originalMargin, originalMargin, outputSizeX - originalMargin, outputSizeY- originalMargin, realMargin1, realMargin1, outputSizeX - realMargin1, outputSizeY - realMargin1, tbWidth1, tbRadius1, originalR, tbr,tbg,tbb, offsetX, offsetY, parameters.size, spec);
                    break;
                case 7:
                    tbRadius1 = tbRadius * smallerSize - i;//(realMargin*0.002 * i * parameters.size);
                    if (tbRadius1 < 0)
                        tbRadius1 = 0;

                    artBox(api, 4, parameters.flip, originalMargin, originalMargin, outputSizeX - originalMargin, outputSizeY- originalMargin, realMargin1, realMargin1, outputSizeX - realMargin1, outputSizeY - realMargin1, tbWidth1, tbRadius1, originalR, tbr,tbg,tbb, offsetX, offsetY, parameters.size, spec);
                    break;

                case 8:
                    tbRadius1 = tbRadius * smallerSize + i/2;//(realMargin*0.002 * i * parameters.size)/2;
                    artBox(api, 4, parameters.flip, originalMargin, originalMargin, outputSizeX - originalMargin, outputSizeY- originalMargin, realMargin1, realMargin1, outputSizeX - realMargin1, outputSizeY - realMargin1, tbWidth1, tbRadius1, originalR, tbr,tbg,tbb, offsetX, offsetY, parameters.size, spec);
                    break;
            }  

        }
    }


function makeSpecArray(specArray, n)
{
    var i = 0;
    var max = 1;
    var min = -1;
    
    var counter = 2;
    
    var y = Engine.rand()*0.5+0.5;  // initial Y
    while (i < 1)
    {

        var length = Engine.rand()*(5/n)+0.05;

  
        var type = 0;
        var a = Engine.rand()*1.0+0.01;
        var b = Engine.rand()*Math.PI;
        var c = Engine.rand()*80-40;
        
        if (Engine.rand() > 0.1) // mostlikely, line continues
            var d = -Math.sin(b)*c;
        else
            var d = Engine.rand()*2-1;
            
            
        i+= length;
        y += Math.sin(a*length+b)*c+d;
        
        if (y < min)                  // not very accurate but ok
            min = y;
        if (y > max)
            max = y;
              
         specArray[counter++] = length;
         specArray[counter++] = a;
         specArray[counter++] = b;
         specArray[counter++] = c;
         specArray[counter++] = d;
              
//                Engine.message(a, "  ", b, "  ", c, "  ", d, "  ", length);
              
              
    }

    specArray[0] = max;
    specArray[1] = min;
    
//    Engine.message(max,"  ", min);
}


function getSpecArray(specArray, l)
{
    var counter = 2;
    var l1 = 0;

    while(l1 <= l && l1 < 1){
        l1 += specArray[counter];
        counter += 5;
    }
    counter -= 5;
    l1 -= specArray[counter++];
    
    var i = l-l1;
    var a = specArray[counter++];
    var b = specArray[counter++];
    var c = specArray[counter++];
    var d = specArray[counter++];
    
    var y = Math.sin(a*i+b)*c+d;

    var max = specArray[0];
    var min = specArray[1];
    
    y = (y-min) * 1.8/(max-min) -0.9;
    
    if (y >= 0.99)
        y = 0.99;
    if (y <= -0.99)
        y = -0.99;

    return y;
}








    var x1 = 0;
    var y1 = 0;
    var x = 0;
    var y = 0;
    
    var lx1 = 0;
    var ly1 = 0;
    var lx = 0;
    var ly = 0;
    
    tWidth *= frameScale;

    x = 0;
    y = 0;
    var hCount = 1/patternRatio;

    var boxRatio = (outputSizeX - realMargin*2)/(outputSizeY - realMargin*2);
    

    if (boxRatio >= 1){
        repeatN = 10;
        var iStep = 0.1/boxRatio;
    }else{
        repeatN = 10/boxRatio;
        var iStep = 0.1;
    }

    api.command(kpsStartTask, 0.8);

    for (var i = 0; i < repeatN; i+= iStep)
    {
        
        api.command(kpsStartTask, 1/repeatN);  // progress bar
        

        x1 = x;
        y1 = y;
        
        lx1 = lx;
        ly1 = ly;
        

        
        lx = positionX(trunkType,i,flip,realMargin,fWidth*frameScale, repeatN, curveRatio, boxRatio);
        ly = positionY(trunkType,i,flip,realMargin,fWidth*frameScale, repeatN, curveRatio, boxRatio); 
   
        x = lx / frameScale;
        y = ly / frameScale;
        

        
        var happens = false;
        switch(patternPattern)
        {
            case 0:
                var patternRatio1 = patternRatio;

                
                if ((boxRatio < 1 && hCount >= (1/patternRatio) / ((outputSizeX-realMargin*2)/(outputSizeX)))||
                    (boxRatio >= 1 && hCount >= (1/patternRatio) / ((outputSizeY-realMargin*2)/(outputSizeY)))){
                    happens = true;
                    hCount = 0;
                }
                hCount ++;
                break;
            
            case 1:
                var patternRatio1 = patternRatio;

                if (hCount >= (1/patternRatio)){
                    happens = true;
                    hCount = 0;
                }
                hCount++;
                break;
            case 2: 
                if (hCount > patternRatio*i*(40)){
                    happens = true
                    hCount = 0;
                }
                hCount++;
                break;
            case 3:
                if (hCount > patternRatio*(500)/i){
                    happens = true
                    hCount = 0;
                }
                hCount++;
                break;
        }


        
        if (happens){
            
            if(basePatternNumber[0] == 0){
                for (var k = 0; k < Math.floor(Engine.rand()*8)+1; k++){
                    var bpn = Math.floor(Engine.rand()*8)+1;
                    var patternFlip = 1;
                    if (Engine.rand()>0.5){
                        patternFlip = -1;
                    }
                    renderTotal++;
                    Engine.addModule(new ModuleCurl(parameters, 0, pType, sColor, cColorFade, curveVisible, angle + angleRatio*i + (Engine.rand()-0.5)*angleRandom + bpn*3.14/4, x, y, 
                    patternFlip,sSize1 + sSizeRatio*i + Math.cos(i)*sSizeCos+ (Engine.rand()-0.5)*sSizeRandom*2, ipWidth, pWidth, spiral, sCircle, sCircleSize, sCircleSizeRatio*i, 
                    sCircleSizeRandom, scColor, tail, boxRatio, i/repeatN, flip, leaves, sLeaves, slPoints, cContinuous, objAngleSnap, cGenerationN, cgSizeRatio, cgSizeRandom, offsetX,offsetY));
                }
            } else {
                for (var k = 0; k < basePatternNumber.length; k++){
                    var bpn = basePatternNumber[k];
                    var patternFlip = 1;
                    if (bpn < 0){
                        bpn = -bpn;
                        patternFlip = -1;
                    }
                    renderTotal++;
                    Engine.addModule(new ModuleCurl(parameters, 0, pType, sColor, cColorFade, curveVisible, angle + angleRatio*i + (Engine.rand()-0.5)*angleRandom + bpn*3.14/4, x, y, 
                    patternFlip,sSize1 + sSizeRatio*i + Math.cos(i)*sSizeCos+ (Engine.rand()-0.5)*sSizeRandom*2, ipWidth, pWidth, spiral, sCircle, sCircleSize, sCircleSizeRatio*i, 
                    sCircleSizeRandom, scColor, tail, boxRatio, i/repeatN, flip, leaves, sLeaves, slPoints, cContinuous, objAngleSnap, cGenerationN, cgSizeRatio, cgSizeRandom, offsetX, offsetY));
                }
            }
        }
    


        
        if(trunk && x1 != 0 && y1 != 0)
        {
            if ( (flip == 1 && i/repeatN < boxRatio) || (flip == 0 && i/repeatN > (1-boxRatio)) ){

                Engine.addModule(new ModuleLine(api, lx,ly, lx1,ly1, tWidth, sColor[0],sColor[1],sColor[2]));
                Engine.addModule(new ModuleLine(api, outputSizeX-lx,ly, outputSizeX-lx1,ly1,tWidth,sColor[0],sColor[1],sColor[2]));
                
                Engine.addModule(new ModuleLine(api, lx,outputSizeY-ly, lx1,outputSizeY-ly1, tWidth, sColor[0],sColor[1],sColor[2]));
                Engine.addModule(new ModuleLine(api, outputSizeX-lx,outputSizeY-ly, outputSizeX-lx1,outputSizeY-ly1, tWidth, sColor[0],sColor[1],sColor[2]));
            }
            if ( (flip == 1 && i/repeatN < 1/boxRatio) || (flip == 0 && i/repeatN > (1-1/boxRatio))){
                Engine.addModule(new ModuleLine(api, ly,lx, ly1,lx1, tWidth, sColor[0],sColor[1],sColor[2]));
                Engine.addModule(new ModuleLine(api, outputSizeX-ly,lx, outputSizeX-ly1,lx1, tWidth, sColor[0],sColor[1],sColor[2]));
                
                Engine.addModule(new ModuleLine(api, ly,outputSizeY-lx, ly1,outputSizeY-lx1, tWidth, sColor[0],sColor[1],sColor[2]));
                Engine.addModule(new ModuleLine(api, outputSizeX-ly,outputSizeY-lx, outputSizeX-ly1,outputSizeY-lx1, tWidth, sColor[0],sColor[1],sColor[2]));
            }

        }
    api.command(kpsFinishTask);
    }



    // Setting the bounding box like this will insure that neighboring fills are aligned
    api.setSceneBBox (0,  outputSize.x,  0,  outputSize.y)

    Engine.setParameter (kRunSimulation, 1)
    Engine.setParameter (kNumSimulationSteps, 1000)


    if (parameters == previewParameters)
    {
        for (var step = 0; step < renderTotal; step++)
            Engine.produce();

        Engine.render (api)
        
     }
  
      api.command(kpsFinishTask);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Menu start
// If you want to create a menu in which you change some of the script parameters, include the following code:
// For shipped scripts we can include localized strings, prefixed with $$$/ - call method localize(string) on the prefixed string
// For your own strings, you can query app.locale and select several language versions (for example, your native language and english). Try alert ("Language is: " + app.locale)

var sBasic = localize("$$$/DecoScripts/Frame/tab1=Basic")
var sAdvanced = localize("$$$/DecoScripts/Frame/tab2=Advanced")

var decoMenu = {    //  an object that defines the menu
   menuTitle : localize("$$$/DecoScripts/Frame/Frame=Frame"),
   //menuBackground : [0.8593, 0.8593, 0.8593, 1],
   previewBackground : [ 1, 1, 1, 1],
    panels : [
    { panelName : sBasic, 
       panelWidth : 450, 
       leftColumnWidth : 180, 
       editTextWidth : 37,
       panelMenu : [
         { itemName : localize("$$$/DecoScripts/Frame/FrameType=Frame:"),  
             itemUnit : "", 
             itemType : 'dropdownlist',  itemList  : 
            [
            { item: localize("$$$/DecoScripts/Frame/Frame1= 1: Happy Vine"),  image : "Picture Frame/f0.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame2= 2: Pretty Vine"),  image : "Picture Frame/f1.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame3= 3: Smoke Signals"),  image : "Picture Frame/f2.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame4= 4: Party"),  image : "Picture Frame/f3.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame5= 5: Big Curls"),  image : "Picture Frame/f4.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame6= 6: Tilde"),  image : "Picture Frame/f5.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame7= 7: Romance"),  image : "Picture Frame/f6.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame8= 8: Curly Dance"),  image : "Picture Frame/f7.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame9= 9: Wisps"),  image : "Picture Frame/f8.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame10=10: Spring Weed"),  image : "Picture Frame/f9.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame11=11: Eyelash"),  image : "Picture Frame/f10.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame12=12: Magic Smoke"),  image : "Picture Frame/f11.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame13=13: Curly Vine"),  image : "Picture Frame/f12.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame14=14: Chainmail"),  image : "Picture Frame/f13.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame15=15: Fun Event"),  image : "Picture Frame/f14.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame16=16: Bush"),  image : "Picture Frame/f15.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame17=17: Simple Lace"),  image : "Picture Frame/f16.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame18=18: Pulse"),  image : "Picture Frame/f17.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame19=19: Root"),  image : "Picture Frame/f18.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame20=20: Snakes"),  image : "Picture Frame/f19.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame21=21: Mustache"),  image : "Picture Frame/f20.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame22=22: Circle Sprinkle"),  image : "Picture Frame/f21.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame23=23: Aligned Flowers"),  image : "Picture Frame/f22.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame24=24: Little Flowers"),  image : "Picture Frame/f23.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame25=25: Snowflakes"),  image : "Picture Frame/f24.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame26=26: Flurry"),  image : "Picture Frame/f25.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame27=27: Check Marks"),  image : "Picture Frame/f26.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame28=28: Focused Lines"),  image : "Picture Frame/f27.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame29=29: Focused Parallel Lines "),   image : "Picture Frame/f28.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame30=30: Focused Vibrating Lines"),  image : "Picture Frame/f29.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame31=31: Zen Garden"),  image : "Picture Frame/f30.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame32=32: Spikes"),  image : "Picture Frame/f31.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame33=33: Anemone"),  image : "Picture Frame/f32.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame34=34: Pinwheel"),  image : "Picture Frame/f33.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame35=35: Spacing"),  image : "Picture Frame/f34.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame36=36: Line Box"),  image : "Picture Frame/f35.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame37=37: Rounded Corners"),  image : "Picture Frame/f36.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame38=38: Inverse Rounded Corners1"),  image : "Picture Frame/f37.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame39=39: Inverse Rounded Corners2"),  image : "Picture Frame/f38.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame40=40: Dual Rounded Corners1"),  image : "Picture Frame/f39.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame41=41: Dual Rounded Corners2"),  image : "Picture Frame/f40.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame42=42: Art Frame"),  image : "Picture Frame/f41.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame43=43: Rounded Art Frame"),  image : "Picture Frame/f42.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame44=44: Inverse Rounded Art Frame1"),  image : "Picture Frame/f43.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame45=45: Inverse Rounded Art Frame2"),  image : "Picture Frame/f44.png" },
            { item: localize("$$$/DecoScripts/Frame/Frame46=46: Dual Rounded Art Frame1"),  image : "Picture Frame/f45.png" }, 
            { item: localize("$$$/DecoScripts/Frame/Frame47=47: Dual Rounded Art Frame2"),  image : "Picture Frame/f46.png" },
            ],
             itemValue : modelParameters.frameNumber, itemMin : 0, itemMax : 100, varName : 'frameNumber', 
             disableItems : [ // optionally, you could specify which items in the current panel will be disabled (grayed out) for a specific selection.
                                    // when selection 1 is chosed (index 0), it grays out menu item Item3 and Item4 (index 2, and 3 - indexed in order items are specified in the panelMenu array - from 0)
                                    // when selection 2 is chosed (index 1), it grays out menu item Item4 (index 3)
             [0, [8,9,10                      ], [sAdvanced, 0]],              
             [1, [8,9,10                      ], [sAdvanced, 0]],              
             [2, [8,9,10                      ], [sAdvanced, 0]],              
             [3, [8,9,10                      ], [sAdvanced, 0]], 
             [4, [sAdvanced, 0]], 
             [5, [8,9,10                      ], [sAdvanced, 0]],
             [6, [8,9,10                      ], [sAdvanced, 0]],
             [7, [8,9,10                      ], [sAdvanced, 0]], 
             [8, [8,9,10                      ], [sAdvanced, 0]], 
             [9, [8,9,10                      ], [sAdvanced, 0]], 
             [10, [sAdvanced, 0]],
             [11, [sAdvanced, 0]],
             [12, [sAdvanced, 0]],
             [13, [8,9,10                      ], [sAdvanced, 0]],
             [14, [8,9,10                      ], [sAdvanced, 0]],             
             [15, [sAdvanced, 0,1]],  
             [16, [8,9,10                      ], [sAdvanced, 0]], 
             [17, [sAdvanced, 0]],
             [18, [sAdvanced, 0]],
             [19, [8,9,10                      ], [sAdvanced, 0]],
             [20, [8,9,10                      ], [sAdvanced, 0]],
             [21, [1,8,9,10                      ], [sAdvanced, 0,1]], 
             [22, [1,8,9,10                      ], [sAdvanced, 0,1]],
             [23, [sAdvanced, 0,1]],
             [24, [1,8,9,10                      ],[sAdvanced, 0,1]],
             [25, [1 ],[sAdvanced, 0,1]],
             [26, [8,9,10                      ], [sAdvanced, 0]], 
             [27, [8,9,10                      ], [sAdvanced, 0]], 
             [28, [8,9,10                      ], [sAdvanced, 0]], 
             [29, [8,9,10                      ], [sAdvanced, 0]],    
             [30, [8,9,10                      ], [sAdvanced, 0]],
             [31, [3,8,9,10                      ], [sAdvanced, 0]],
             [32, [8,9,10                      ], [sAdvanced, 0]],
             [33, [8,9,10                      ], [sAdvanced, 0]],
             [34, [1,3,8,9,10                      ],[sAdvanced, 0,1]],
             
             [35, [4,5,6,7,8,9,10],[sAdvanced, 2,3]],
             [36, [4,5,6,7,8,9.10               ],[sAdvanced, 3]],
             [37, [4,5,6,7,8,9.10               ],[sAdvanced, 3]],
             [38, [4,5,6,7,8,9.10               ],[sAdvanced, 3]],
             [39, [4,5,6,7,8,9.10               ],[sAdvanced, 3]],
             [40, [4,5,6,7,8,9.10               ],[sAdvanced, 3]],
             
             [41, [5,6,7,8,9,10],[sAdvanced, 1,2,3]],
             [42, [5,6,7,8,9,10         ],[sAdvanced, 1,3]],
             [43, [5,6,7,8,9,10         ],[sAdvanced, 1,3]],
             [44, [5,6,7,8,9,10         ],[sAdvanced, 1,3]],
             [45, [5,6,7,8,9,10         ],[sAdvanced, 1,3]],
             [46, [5,6,7,8,9,10         ],[sAdvanced, 1,3]],
             
             ]  }, 

         { itemName : localize("$$$/DecoScripts/Frame/VColor=Vine Color:"),
             itemUnit : "",  itemType : 'colorpicker', itemValue : modelParameters.vcolor, varName : 'vcolor'  },

          { itemName : localize("$$$/DecoScripts/Frame/FrameMargin=Margin:") ,
             itemUnit : "", //localize("$$$/DecoScripts/Units/percentOfMargin=%"),  
             itemType : 'slider', itemValue : modelParameters.frameMargin, itemMin : 1, itemMax : 100, itemStep : 1, varName : 'frameMargin'  }, 

          { itemName : localize("$$$/DecoScripts/Frame/Size=Size:"),  
             itemUnit : "",  itemType : 'slider', itemValue : modelParameters.size, itemMin : 1, itemMax : 100, itemStep : 1, varName : 'size'  }, 


          { itemName : localize("$$$/DecoScripts/Frame/Arrange=Arrangement:"),  
             itemUnit : "",  itemType : 'slider', itemValue : modelParameters.arrange, itemMin : 1, itemMax : 200, itemStep : 1, varName : 'arrange'  }, 
         


//          { itemName : localize("$$$/DecoScripts/Frame/BG=Use BG color for vines/icons:"),
//             itemUnit : "",  itemType : 'checkbox', itemValue : modelParameters.bg, itemMin : 0, itemMax : 0, varName : 'bgColor'  },
        



         
         { itemName : localize("$$$/DecoScripts/Frame/FlowerType=Flower:"),  
             itemUnit : "", 
             itemType : 'dropdownlist',  itemList  : 
            [
            { item: localize("$$$/DecoScripts/Frame/Flower0= None"),  image : "Picture Frame/0.png" },
            { item: localize("$$$/DecoScripts/Frame/Flower1= 1: Small Circle"),  image : "Picture Frame/1.png" },
            { item: localize("$$$/DecoScripts/Frame/Flower2= 2: Circle"),           image : "Picture Frame/2.png" },
            { item: localize("$$$/DecoScripts/Frame/Flower3= 3: Star Flower"),   image : "Picture Frame/3.png" },
            { item: localize("$$$/DecoScripts/Frame/Flower4= 4: Small Flower"), image : "Picture Frame/4.png" },
            { item: localize("$$$/DecoScripts/Frame/Flower5= 5: Orbit"),            image : "Picture Frame/5.png" },
            { item: localize("$$$/DecoScripts/Frame/Flower6= 6: Pinwheel"),      image : "Picture Frame/6.png" },
            { item: localize("$$$/DecoScripts/Frame/Flower7= 7: Petals"),          image : "Picture Frame/7.png" },
            { item: localize("$$$/DecoScripts/Frame/Flower8= 8: Sunflower Gate"), image : "Picture Frame/8.png" },
            { item: localize("$$$/DecoScripts/Frame/Flower9= 9: Rose"),           image : "Picture Frame/9.png" },
            { item: localize("$$$/DecoScripts/Frame/Flower10=10: Grass Circle"), image : "Picture Frame/10.png" },
            { item: localize("$$$/DecoScripts/Frame/Flower11=11: Sun"),            image : "Picture Frame/11.png" },
            { item: localize("$$$/DecoScripts/Frame/Flower12=12: Broken Line Circle"), image : "Picture Frame/12.png" },
            { item: localize("$$$/DecoScripts/Frame/Flower13=13: Magical Door"), image : "Picture Frame/13.png" },
            { item: localize("$$$/DecoScripts/Frame/Flower14=14: Twinkle"),       image : "Picture Frame/14.png" },
            { item: localize("$$$/DecoScripts/Frame/Flower15=15: Shiny Star"),   image : "Picture Frame/15.png" },
            { item: localize("$$$/DecoScripts/Frame/Flower16=16: Star Cloud"),   image : "Picture Frame/16.png" },
            { item: localize("$$$/DecoScripts/Frame/Flower17=17: Round Plus"),  image : "Picture Frame/17.png" },
            { item: localize("$$$/DecoScripts/Frame/Flower18=18: Plus Mark"),   image : "Picture Frame/18.png" },
            { item: localize("$$$/DecoScripts/Frame/Flower19=19: Heart"),         image : "Picture Frame/19.png" },
            { item: localize("$$$/DecoScripts/Frame/Flower20=20: Star"),           image : "Picture Frame/20.png" },
            { item: localize("$$$/DecoScripts/Frame/Flower21=21: Snow Flake"), image : "Picture Frame/21.png" },
            { item: localize("$$$/DecoScripts/Frame/Flower22=22: Cat's Footprint"), image : "Picture Frame/22.png" }
            ],
             itemValue : modelParameters.flowerNumber, itemMin : 0, itemMax : 20, varName : 'flowerNumber' },

         { itemName : localize("$$$/DecoScripts/Frame/FColor=Flower Color:"),
             itemUnit : "",  itemType : 'colorpicker', itemValue : modelParameters.fcolor, varName : 'fcolor'  },
         
         { itemName : localize("$$$/DecoScripts/Frame/FlowerSize=Flower Size:"),  
             itemUnit : "",  itemType : 'slider', itemValue : modelParameters.flowerSize, itemMin : 1, itemMax : 100, itemStep : 1, varName : 'flowerSize'  }, 
         
         { itemName : localize("$$$/DecoScripts/Frame/LeafType=Leaf:"),  
             itemUnit : "", 
             itemType : 'dropdownlist',  itemList  : 
            [
            { item: localize("$$$/DecoScripts/Frame/Leaf0= None"),  image : "Picture Frame/L_.png" },
            { item: localize("$$$/DecoScripts/Frame/Leaf1= 1: Circle"),         image : "Picture Frame/L0.png" },
            { item: localize("$$$/DecoScripts/Frame/Leaf2= 2: Square"),      image : "Picture Frame/L1.png" },
            { item: localize("$$$/DecoScripts/Frame/Leaf3= 3: Drop 1"),       image : "Picture Frame/L2.png" },
            { item: localize("$$$/DecoScripts/Frame/Leaf4= 4: Leaf 1"),        image : "Picture Frame/L3.png" },
            { item: localize("$$$/DecoScripts/Frame/Leaf5= 5: Drop 2"),       image : "Picture Frame/L4.png" },
            { item: localize("$$$/DecoScripts/Frame/Leaf6= 6: Drop 3"),       image : "Picture Frame/L5.png" },
            { item: localize("$$$/DecoScripts/Frame/Leaf7= 7: Leaf 2"),        image : "Picture Frame/L6.png" },
            { item: localize("$$$/DecoScripts/Frame/Leaf8= 8: Puff"),           image : "Picture Frame/L7.png" },
            { item: localize("$$$/DecoScripts/Frame/Leaf9= 9: Leaf 3"),         image : "Picture Frame/L8.png" },
            { item: localize("$$$/DecoScripts/Frame/Leaf10=10: Ginkgo leaf"), image : "Picture Frame/L9.png" },
            { item: localize("$$$/DecoScripts/Frame/Leaf11=11: Triangle"),    image : "Picture Frame/L10.png" },
            { item: localize("$$$/DecoScripts/Frame/Leaf12=12: Leaf 4"),       image : "Picture Frame/L11.png" },
            { item: localize("$$$/DecoScripts/Frame/Leaf13=13: Star 1"),       image : "Picture Frame/L12.png" },
            { item: localize("$$$/DecoScripts/Frame/Leaf14=14: Oval"),         image : "Picture Frame/L13.png" },
            { item: localize("$$$/DecoScripts/Frame/Leaf15=15: Trapezoid"),  image : "Picture Frame/L14.png" },
            { item: localize("$$$/DecoScripts/Frame/Leaf16=16: Lollipop 1"),   image : "Picture Frame/L15.png" },
            { item: localize("$$$/DecoScripts/Frame/Leaf17=17: Leaf 5"),       image : "Picture Frame/L16.png" },
            { item: localize("$$$/DecoScripts/Frame/Leaf18=18: Star 2"),       image : "Picture Frame/L17.png" },
            { item: localize("$$$/DecoScripts/Frame/Leaf19=19: Lollipop 2"),   image : "Picture Frame/L18.png" },
            { item: localize("$$$/DecoScripts/Frame/Leaf20=20: Cross"),        image : "Picture Frame/L19.png" },
            { item: localize("$$$/DecoScripts/Frame/Leaf21=21: Heart"),        image : "Picture Frame/L20.png" },
            { item: localize("$$$/DecoScripts/Frame/Leaf22=22: T"),             image : "Picture Frame/L21.png" },
            { item: localize("$$$/DecoScripts/Frame/Leaf23=23: Star 3"),       image : "Picture Frame/L22.png" }

            ],
             itemValue : modelParameters.leafNumber, itemMin : 0, itemMax : 23, varName : 'leafNumber' },
         
         { itemName : localize("$$$/DecoScripts/Frame/LColor=Leaf Color:"),
             itemUnit : "",  itemType : 'colorpicker', itemValue : modelParameters.lcolor, varName : 'lcolor'  },
         
         { itemName : localize("$$$/DecoScripts/Frame/LeafSize=Leaf Size:"),  
             itemUnit : "",  itemType : 'slider', itemValue : modelParameters.leafSize, itemMin : 1, itemMax : 100, itemStep : 1, varName : 'leafSize'  }, 
         

         
       ] },
   
   
   
   
    { panelName : sAdvanced, 
       panelWidth : 450, 
       leftColumnWidth : 180, 
       editTextWidth : 37,
       panelMenu : [
 


          { itemName : localize("$$$/DecoScripts/Frame/nLines=Number of Lines:"),  
             itemUnit : "",  itemType : 'slider', itemValue : modelParameters.nlines, itemMin : 1, itemMax : 30, itemStep : 1, varName : 'nlines'  }, 

          { itemName : localize("$$$/DecoScripts/Frame/Width=Thickness:"),  
             itemUnit : "",  itemType : 'slider', itemValue : modelParameters.width, itemMin : 1, itemMax : 200, itemStep : 1, varName : 'width'  }, 

          { itemName : localize("$$$/DecoScripts/Frame/Angle=Angle:"),  
             itemUnit : "",  itemType : 'slider', itemValue : modelParameters.angle, itemMin : 0, itemMax : 360, itemStep : 0.1, varName : 'angle'  }, 

          { itemName : localize("$$$/DecoScripts/Frame/opacity=Fade:"),  
             itemUnit : "",  itemType : 'slider', itemValue : modelParameters.fade, itemMin : 0, itemMax : 100, itemStep : 1, varName : 'fade'  }, 


        
          { itemName : localize("$$$/DecoScripts/Frame/Flip=Invert"),
             itemUnit : "",  itemType : 'checkbox', itemValue : modelParameters.flip, itemMin : 0, itemMax : 0, varName : 'flip'  },

         
       ] }
   
   
   
   









   ]  // end of panels
 }; // end of menu

// If livePreview is set to 1, the preview image is updated live. Note that due to limitations of scripted menus the update is slow and the flickering may be disturbing. 
livePreview = 0 // recommended value is 0

// Call Photoshop Script that creates the menu
Engine.evalFile ("_Deco Menu.jsx") 

// Menu finished
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

if (typeof skipRun == 'undefined' || !skipRun)  // run unles we exited the preview window without pressing a button
    run(RenderAPI, modelParameters, 1)

